#include "UserEdit.h"

void ViewPrefs(void);
BOOL GetEditor(char, char *);
BOOL GetProto(char, char *);
BOOL GetArchiver(char, char *);
BOOL GetMenuSet(char, char *);
BOOL GetCharSet(char, char *);
char SelectEditor(void);
char SelectProto(char *);
char SelectArc(void);
char SelectMenuSet(void);
char SelectCharSet(void);
BOOL ChkEditor(char num);
BOOL ChkProto(char num);
BOOL ChkArc(char num);
BOOL ChkMenu(char num);
BOOL ChkChar(char num);


/// EditPrefs
void EditPrefs(void)
{
   BOOL  Write    = FALSE;
   BOOL  b        = FALSE;
   char  c[2];
   int   i;

   while(TRUE)
   {
      ViewPrefs();

      DLGInput("Select letter to edit parameter -> ",NULL,c,NULL,1,1,1);
      TwoLines();

///   Change Screen Len (A)
      if(!Strnicmp(c,"A",1))
      {
         if(Same)
         {
            for(i = 70; i > 2; i--)
               AFPrintf(&UserDat,sout,"%d\n",i);

            OneLine();

            i = IntQuery("What is the number at the top of the screen? -> ",1,70,0,&uin);
         }
         else
         {
            i = IntQuery("New Screen Length -> ",1,70,0,&uin);
         }

         TwoLines();

         if(i == 0) continue;

         udat.Screen_Len = i;
         AFPrintf(&UserDat,sout,"%a7Changed!\n\n");
         Write = TRUE;
      }
//-

///   Change Screen Width (B)
      if(!Strnicmp(c,"B",1))
      {
         i = IntQuery("New Screen Width -> ",1,132,0,&uin);
         TwoLines();

         if(i == 0) continue;

         udat.Screen_Width = i;
         AFPrintf(&UserDat,sout,"%a7Changed!\n\n");
         Write = TRUE;
      }
//-

///   Change ANSI Color (C)
      if(!Strnicmp(c,"C",1))
      {
         BOOL   Old;

         if(Same)
         {
            struct USER_DATA tu;

            if(udat.Ansi_Flag & ANSI_COLOR) Old = TRUE;

            memcpy(&tu,&udat,sizeof(struct USER_DATA));

            tu.Ansi_Flag = tu.Ansi_Flag | ANSI_COLOR;
            Clr(udat.Ansi_Flag);
            AFPrintf(&udat,sout,"%a6No Color       |  With Color\n");
            AFPrintf(&udat,sout,"%a7---------------+-------------\n");
            AFPrintf(&udat,sout,"%a7");
            AFPrintf(&tu,  sout,"Red  on Black  | %b0%a1Red on Black%a7\n");
            AFPrintf(&tu,  sout,"Red  on White  | %b7%a1Red on White%b0%a7\n");
            AFPrintf(&udat,sout,"%a7---------------+-------------\n");
            OneLine();
            AFPrintf(&udat,sout,"If the above colors look right, you can use ANSI color.\n\n");
         }

         b = BoolQuery("Enable ANSI color? -> ",FALSE,&uin);
         TwoLines();

         if(b != Old)
         {
            if(b)
               udat.Ansi_Flag = udat.Ansi_Flag | ANSI_COLOR;
            else
               udat.Ansi_Flag = udat.Ansi_Flag & ~ANSI_COLOR;

            AFPrintf(&UserDat,sout,"%a7Changed!\n\n");
            Write = TRUE;
         }
      }
//-

///   Change ANSI Positioning (D)
      if(!Strnicmp(c,"D",1))
      {
         BOOL   Old;

         if(Same)
         {
            struct USER_DATA tu;

            if(udat.Ansi_Flag & ANSI_POS) Old = TRUE;

            memcpy(&tu,&udat,sizeof(struct USER_DATA));

            tu.Ansi_Flag = tu.Ansi_Flag | ANSI_POS;
            Clr(udat.Ansi_Flag);
            AFPrintf(&tu,sout,".---------------------------.\n");
            AFPrintf(&tu,sout,"|");
            PrintSpace(sout,tu.Ansi_Flag,27);
            AFPrintf(&tu,sout,"|\n");
            AFPrintf(&tu,sout,"|");
            PrintSpace(sout,tu.Ansi_Flag,27);
            AFPrintf(&tu,sout,"|\n");
            AFPrintf(&tu,sout,"`---------------------------'\n");
            OneLine();
            AFPrintf(&tu,sout,"If the sides of the box line up, you can use\n");
            AFPrintf(&tu,sout,"ANSI cursor positioning.\n\n");
         }

         b = BoolQuery("Enable ANSI screen positioning? -> ",FALSE,&uin);
         TwoLines();

         if(b != Old)
         {
            if(b)
               udat.Ansi_Flag = udat.Ansi_Flag | ANSI_POS;
            else
               udat.Ansi_Flag = udat.Ansi_Flag & ~ANSI_POS;

            AFPrintf(&UserDat,sout,"%a7Changed!\n\n");
            Write = TRUE;
         }
      }
//-

///   Change Screen Clears (E)
      if(!Strnicmp(c,"E",1))
      {
         BOOL   Old;

         if(Same)
         {
            struct USER_DATA tu;

            if(udat.Ansi_Flag & ANSI_CLR) Old = TRUE;

            memcpy(&tu,&udat,sizeof(struct USER_DATA));

            tu.Ansi_Flag = tu.Ansi_Flag | ANSI_CLR;
            AFPrintf(&tu,sout,".---------------------------.\n");
            AFPrintf(&tu,sout,"|");
            PrintSpace(sout,tu.Ansi_Flag,27);
            AFPrintf(&tu,sout,"|\n");
            AFPrintf(&tu,sout,"|");
            PrintSpace(sout,tu.Ansi_Flag,27);
            AFPrintf(&tu,sout,"|\n");
            AFPrintf(&tu,sout,"`---------------------------'\n");
            TwoLines();

            Clr(tu.Ansi_Flag);

            OneLine();
            AFPrintf(&tu,sout,"If you see a box, then your terminal does\n");
            AFPrintf(&tu,sout,"not support ANSI screen clears.\n\n");
         }

         b = BoolQuery("Enable ANSI screen clears? -> ",FALSE,&uin);
         TwoLines();

         if(b != Old)
         {
            if(b)
               udat.Ansi_Flag = udat.Ansi_Flag | ANSI_CLR;
            else
               udat.Ansi_Flag = udat.Ansi_Flag & ~ANSI_CLR;

            AFPrintf(&UserDat,sout,"%a7Changed!\n\n");
            Write = TRUE;
         }
      }
//-

///   Change Scrolling (F)
      if(!Strnicmp(c,"F",1))
      {


         BOOL   Old;

         if(Same)
         {

///         The text
            char *Buf = {
                           "11 -- (Screen Length) This value is the maximum number of text lines that your terminal is capable of displaying. This value interacts with the More option, discussed below. If, when you are reading messages, the top of the message scrolls off of your terminal screen before the More prompt appears, then you have your Screen Length set too high.\n\n"
                           "12 -- (More) This command toggles the MORE prompt on or off. Here is how the MORE prompt works: If you are reading a message which is longer than your current Screen Length, the BBS will display text until the screen fills up, and then it will display a short prompt like this:\n\n"
                           "              More? (Y/n/=)\n\n"
                           "      To continue reading, you merely have to press RETURN or ENTER on your keyboard. The reason for the MORE prompt is that at fast baud rates, text often displays and scrolls by on the screen faster than you can read it. The MORE prompt lets the screen fill up with text, and then pauses to give you a chance to catch up. If you decide that the message was on a topic which does not interest you, then press 'n' on your keyboard. The BBS will stop printing that message altogether. If you find the MORE prompt distracting, then you can turn it off with this command.\n\n"
                           "13 -- (Screen Width) This value is the maximum number of characters across that your terminal is capable of displaying. This value determines where the word wrap function will split lines, so that text will look the best on your screen. If displayed messages look odd on your terminal screen, chances are that you do not have your terminal width set correctly.\n\n"
                           "14 -- (Ansi Graphics) This command allows you to change several ANSI graphic features of DLG. ANSI graphics are a set of character/command protocols supported by many different computer models and terminal software. ANSI controls can rapidly re-position the text cursor on the screen, clear the screen to avoid slow scrolling, add a touch of colour, or add special effects such as partial screen scrolling to allow message headers to remain stationary while paging or scrolling the contents of a message.\n\n"
                           "15 -- (Hot Keys) This will allow you to make use of single key-press command choices at many DLG prompts, without the need to press RETURN or ENTER after the command selection. Note that you can still make use of Command Stacking (a feature which lets you enter several commands at a single prompt) when you have Hot Keys active by prefacing the command stack with a semi-colon (;).\n\n"
                        };
//-
            struct USER_DATA tu;
            USHORT pos = 8;

            if(!(UserDat.Ansi_Flag & ANSI_CLR))
            {
               AFPrintf(&UserDat,sout,"You must ave ANSI screen clears enabled for\n");
               AFPrintf(&UserDat,sout,"ANSI scrolling to work properly.\n\n");
               Pause();
               continue;
            }

            AFPrintf(&UserDat,sout,"Now you will be shown a sample 'header' followed\n");
            AFPrintf(&UserDat,sout,"by some sample text. The header should stay stationary\n");
            AFPrintf(&UserDat,sout,"at the top of the screen, while the sample text will\n");
            AFPrintf(&UserDat,sout,"'scroll' as if it is contained within a window. If all\n");
            AFPrintf(&UserDat,sout,"looks well, your terminal supports the high-end ANSI\n");
            AFPrintf(&UserDat,sout,"sequences that make this possible.  If not, disable the\n");
            AFPrintf(&UserDat,sout,"ANSI Screen Scrolling option.\n\n");
            Pause();


            if(UserDat.Ansi_Flag & ANSI_SCROLL) Old = TRUE;
            memcpy(&tu,&udat,sizeof(struct USER_DATA));
            tu.Ansi_Flag = tu.Ansi_Flag | ANSI_SCROLL;

            Clr(UserDat.Ansi_Flag);

            AFPrintf(&UserDat,sout,"%a3.---------------------------.\n");
            AFPrintf(&UserDat,sout,"%a3|\n");
            AFPrintf(&UserDat,sout,"%a3| %a6This header should stay in place\n");
            AFPrintf(&UserDat,sout,"%a3|\n");
            AFPrintf(&UserDat,sout,"%a3|\n");
            AFPrintf(&UserDat,sout,"%a3`--------------------------------------------%a7\n\n");

            DispBuffer(sout,Buf,&pos,0,NULL,8,"\003",&tu);
            Pause();

            OneLine();
            AFPrintf(&tu,sout,"If all looked correct, your terminal supports ANSI Screen Scrolling.\n\n");
         }

         b = BoolQuery("Enable ANSI screen scrolling? -> ",FALSE,&uin);
         TwoLines();

         if(b != Old)
         {
            if(b)
               udat.Ansi_Flag = udat.Ansi_Flag | ANSI_SCROLL;
            else
               udat.Ansi_Flag = udat.Ansi_Flag & ~ANSI_SCROLL;

            AFPrintf(&UserDat,sout,"%a7Changed!\n\n");
            Write = TRUE;
         }
      }
//-

///   Change More Prompt (G)
      if(!Strnicmp(c,"G",1))
      {
         BOOL   Old;

         if(udat.More_Flag == 1)
            Old = TRUE;
         else
            Old = FALSE;

         if(Same)
         {

            AFPrintf(&UserDat,sout,"\nIf you disable the MORE prompt, all text that is displayed\n");
            AFPrintf(&UserDat,sout,"will be displayed in CONTINUOUS mode, meaning that there will\n");
            AFPrintf(&UserDat,sout,"be no pauses for long text displays. If you enable the MORE\n");
            AFPrintf(&UserDat,sout,"prompt, text display will pause after your screen is filled\n");
            AFPrintf(&UserDat,sout,"and will await your input before continuing.\n\n");
         }

         b = BoolQuery("Enable MORE prompt? -> ",TRUE,&uin);
         TwoLines();

         if(b != Old)
         {
            udat.More_Flag = (char)b;
            AFPrintf(&UserDat,sout,"%a7Changed!\n\n");
            Write = TRUE;
         }
      }
//-

///   Change Hot Keys (I)
      if(!Strnicmp(c,"I",1))
      {
         BOOL   Old;

         if(udat.Hot_Keys == 1)
            Old = TRUE;
         else
            Old = FALSE;

         if(Same)
         {
            AFPrintf(&UserDat,sout,"\nHOT KEYS allow you to select menu options with one key stroke.\n");
            AFPrintf(&UserDat,sout,"If you disable Hot Keys, you will have to hit RETURN (ENTER)\n");
            AFPrintf(&UserDat,sout,"every time you with to make a selection on a menu.\n\n");
         }

         b = BoolQuery("Enable Hot Keys? -> ",FALSE,&uin);
         TwoLines();

         if(b != Old)
         {
            udat.Hot_Keys = (char)b;
            AFPrintf(&UserDat,sout,"%a7Changed!\n\n");
            Write = TRUE;
         }
      }
//-

///   Change Help Level (J)
      if(!Strnicmp(c,"J",1))
      {
         char Old;

         Old = udat.Help_Level;

         if(Same)
            AFPrintf(&UserDat,sout,"\nYou have a choice of three help levels:\n\n");

         AFPrintf(&UserDat,sout,"%a71%a3 - %a6NOVICE       %a3-  %a2Most menus are displayed completely.\n");
         AFPrintf(&UserDat,sout,"%a72%a3 - %a6INTERMEDIATE %a3-  %a2Most Menus display a summary of valid\n");
         AFPrintf(&UserDat,sout,"                                %a2keystrokes in the command prompt.\n");
         AFPrintf(&UserDat,sout,"%a73%a3 - %a6EXPERT       %a3-  %a2No menus, no keystrokes in prompts.%a7\n\n");

         if(Same)
            AFPrintf(&UserDat,sout,"Full menus are displayed with the '?' key in any mode.\n\n");

         i = IntQuery("Help Level -> ",1,3,1,&uin);

         TwoLines();

         if(Old != (i-1))
         {
            udat.Help_Level = i-1;
            AFPrintf(&UserDat,sout,"%a7Changed!\n\n");
            Write = TRUE;
         }
      }
//-

///   Change Text Editor (K)
      if(!Strnicmp(c,"K",1))
      {
         c[0] = SelectEditor();

         if(ChkEditor(c[0]))
         {
            if(c[0] != udat.Editor)
            {
               udat.Editor = c[0];
               AFPrintf(&UserDat,sout,"%a7Changed!\n\n");
               Write = TRUE;
            }
         }
         else
         {
            AFPrintf(&UserDat,sout,"\n%a6Invalid Selection!\n");
            Pause();

            if(udat.Editor != 0)
            {
               if(!ChkEditor(udat.Editor))
               {
                  udat.Editor = 0;
                  Write = TRUE;
               }
            }
         }
      }
//-

///   Change Upload Protocol (L)
      if(!Strnicmp(c,"L",1))
      {
         SelectProto(c);

         if(ChkProto(c[0]))
         {
            if(c[0] != udat.send)
            {
               udat.send = c[0];
               AFPrintf(&UserDat,sout,"%a7Changed!\n\n");
               Write = TRUE;
            }
         }
         else
         {
            AFPrintf(&UserDat,sout,"\n%a6Invalid Selection!\n");
            Pause();

            if(udat.send != 0)
            {
               if(!ChkProto(udat.send))
               {
                  udat.send = 0;
                  Write = TRUE;
               }
            }
         }

         c[0] = 0;
      }
//-

///   Change Download Protocol (M)
      if(!Strnicmp(c,"M",1))
      {
         SelectProto(c);

         if(ChkProto(c[0]))
         {
            if(c[0] != udat.receive)
            {
               udat.receive = c[0];
               AFPrintf(&UserDat,sout,"%a7Changed!\n\n");
               Write = TRUE;
            }
         }
         else
         {
            AFPrintf(&UserDat,sout,"\n%a6Invalid Selection!\n");
            Pause();

            if(udat.receive != 0)
            {
               if(!ChkProto(udat.receive))
               {
                  udat.receive = 0;
                  Write = TRUE;
               }
            }
         }

         c[0] = 0;
      }
//-

///   Change Archiver (N)
      if(!Strnicmp(c,"N",1))
      {
         c[0] = SelectArc();

         if(ChkArc(c[0]))
         {
            if(c[0] != udat.archiver)
            {
               udat.archiver = c[0];
               AFPrintf(&UserDat,sout,"%a7Changed!\n\n");
               Write = TRUE;
            }
         }
         else
         {
            AFPrintf(&UserDat,sout,"\n%a6Invalid Selection!\n");
            Pause();

            if(udat.archiver != 0)
            {
               if(!ChkArc(udat.archiver))
               {
                  udat.archiver = 0;
                  Write = TRUE;
               }
            }
         }
      }
//-

///   Change Menu Set (O)
      if(!Strnicmp(c,"O",1))
      {
         c[0] = SelectMenuSet();

         if(ChkMenu(c[0]))
         {
            if(c[0] != udat.menuset)
            {
               udat.menuset = c[0];
               AFPrintf(&UserDat,sout,"%a7Changed!\n\n");
               Write = TRUE;
            }
         }
         else
         {
            AFPrintf(&UserDat,sout,"\n%a6Invalid Selection!\n");
            Pause();

            if(udat.menuset !=0)
            {
               if(!ChkMenu(udat.menuset))
               {
                  udat.menuset = 0;
                  Write = TRUE;
               }
            }
         }
      }
//-

///   Change Character Set (P)
      if(!Strnicmp(c,"P",1))
      {
         c[0] = SelectCharSet();

         if(ChkChar(c[0]))
         {
            if(c[0] != udat.charset)
            {
               udat.charset = c[0];
               AFPrintf(&UserDat,sout,"%a7Changed!\n\n");
               Write = TRUE;
            }
         }
         else
         {
            AFPrintf(&UserDat,sout,"\n%a6Invalid Selection!\n");
            Pause();

            if(udat.charset !=0)
            {
               if(!ChkChar(udat.charset))
               {
                  udat.charset = 0;
                  Write = TRUE;
               }
            }
         }
      }
//-

///   Exit
      if(!Strnicmp(c,"X",1))
      {
         if(Write)
         {
            struct NameStruct ns;

            strcpy(ns.name,name);

            if(0 == DeleteStruct(NAMERECORD,(char *)&ns,sizeof(struct NameStruct),30))
            {
               char fname[128];

               strcpy(ns.alias,udat.Alias);
               strcpy(ns.email,udat.Email);
               AddStruct(NAMERECORD,(char *)&ns,sizeof(struct NameStruct),30);

               ASPrintf(NULL,fname,"USER:%s/User.Data",name);
               UnderScore(fname);

               if(Same) memcpy(&UserDat,&udat,sizeof(struct USER_DATA));
               DeleteFile(fname);
               DumpFile(fname,(char *)&udat,sizeof(struct USER_DATA));
            }

            AFPrintf(&UserDat,sout,"%a7Changes saved.\n\n");
            Pause();
         }
         else
         {
            AFPrintf(&UserDat,sout,"%a7User record unchanged.\n\n");
            Pause();
         }

         break;
      }
//-

///   Quit
      if(!Strnicmp(c,"Q",1))
      {
         if(Write)
         {
            AFPrintf(&UserDat,sout,"%b7 %a1NOTE: %b0%a7 Changes not saved!\n\n");
            Pause();
         }

         break;
      }
//-

   }

   return;
}
//-

/// ViewPersonal()
void ViewPrefs(void)
{
   char temp[61]; // Biggest field == 60 so this will hold it fine

   Clr(UserDat.Ansi_Flag);
   AFPrintf(&UserDat,sout,"\n%a6 System Preferences for user %a2[%au%a7%s%ao%a2]%a7\n",name);
   Draw_Line(UserDat.Screen_Width);

   AFPrintf(&UserDat,sout,"%b0%a2[%a7A%a2] %a6Screen Length ........... %b7%a4 %-3d ",udat.Screen_Len);
   AFPrintf(&UserDat,sout,"%b0 %a2[%a7B%a2] %a6Screen Width ............. %b7%a4 %-3d \n",udat.Screen_Width);

   AFPrintf(&UserDat,sout,"%b0%a2[%a7C%a2] %a6ANSI Color .............. %b7%a4 %-3.3s ",(udat.Ansi_Flag & ANSI_COLOR) ? "Yes" : "No");
   AFPrintf(&UserDat,sout,"%b0 %a2[%a7D%a2] %a6ANSI Cursor Positioning .. %b7%a4 %-3.3s \n",(udat.Ansi_Flag & ANSI_POS) ? "Yes" : "No");

   AFPrintf(&UserDat,sout,"%b0%a2[%a7E%a2] %a6Screen Clears ........... %b7%a4 %-3.3s ",(udat.Ansi_Flag & ANSI_CLR) ? "Yes" : "No");
   AFPrintf(&UserDat,sout,"%b0 %a2[%a7F%a2] %a6Partial Screen Scrolling . %b7%a4 %-3.3s \n",(udat.Ansi_Flag & ANSI_SCROLL) ? "Yes" : "No");

   AFPrintf(&UserDat,sout,"%b0%a7");
   Draw_Line(UserDat.Screen_Width);

   AFPrintf(&UserDat,sout,"%b0%a2[%a7G%a2] %a6'More' Prompt ........... %b7%a4 %-3.3s ",udat.More_Flag ? "Yes": "No");
   AFPrintf(&UserDat,sout,"%b0 %a2[%a7I%a2] %a6Hot Keys ................. %b7%a4 %-3.3s \n",udat.Hot_Keys ?"Yes" : "No");

   AFPrintf(&UserDat,sout,"%b0%a7");
   Draw_Line(UserDat.Screen_Width);

   AFPrintf(&UserDat,sout,"%b0%a2[%a7J%a2] %a6Help Level ........ %b7%a4 ");

   switch(udat.Help_Level)
   {
      case 0 :
         AFPrintf(&UserDat,sout,"%-12.12s ","Novice");
         break;
      case 1 :
         AFPrintf(&UserDat,sout,"%-12.12s ","Intermediate");
         break;
      case 2 :
         AFPrintf(&UserDat,sout,"%-12.12s ","Expert");
         break;
      default:
         AFPrintf(&UserDat,sout,"%a1%-12.12s ","Error!");
         break;
   }

   OneLine();

   if(!GetEditor(udat.Editor,temp))
      strcpy(temp,"None Selected");

   AFPrintf(&UserDat,sout,"%b0%a2[%a7K%a2] %a6Text Editor ....... %b7%a4 %-50.50s \n",temp);

   if(!GetProto(udat.send,temp))
      strcpy(temp,"None Selected");

   AFPrintf(&UserDat,sout,"%b0%a2[%a7L%a2] %a6Upload Protocol ... %b7%a4 %-50.50s \n",temp);

   if(!GetProto(udat.receive,temp))
      strcpy(temp,"None Selected");

   AFPrintf(&UserDat,sout,"%b0%a2[%a7M%a2] %a6Download Protocol . %b7%a4 %-50.50s \n",temp);

   if(!GetArchiver(udat.archiver,temp))
      strcpy(temp,"None Selected");

   AFPrintf(&UserDat,sout,"%b0%a2[%a7N%a2] %a6Archiver .......... %b7%a4 %-50.50s \n",temp);

   if(!GetMenuSet(udat.menuset,temp))
      strcpy(temp,"Default");

   AFPrintf(&UserDat,sout,"%b0%a2[%a7O%a2] %a6Menu Set .......... %b7%a4 %-50.50s \n",temp);

   if(!GetCharSet(udat.charset,temp))
      strcpy(temp,"Default");

   AFPrintf(&UserDat,sout,"%b0%a2[%a7P%a2] %a6Character Set ..... %b7%a4 %-50.50s \n",temp);

   AFPrintf(&UserDat,sout,"%b0%a7");
   Draw_Line(UserDat.Screen_Width);

   AFPrintf(&UserDat,sout,"%a2[%a7H%a2] %a6Help    %a2[%a7?%a2] %a6Re-Display    %a2[%a7X%a2] %a6Save and Exit   %a2[%a7Q%a2] %a6Quit (no save)%a7\n");
   Draw_Line(UserDat.Screen_Width);
   OneLine();

   return;
}
//-

/// GetEditor()
BOOL GetEditor(char type, char *EdName)
{
   BPTR     fh;
   struct   Editor   ed;

   if(type == 0)
   {
      strcpy(EdName,"None Selected");
      return(FALSE);
   }

   fh = Open("DLGConfig:Misc/Editors.BBS",MODE_OLDFILE);

   if(!fh)
   {
      strcpy(EdName,"None Selected");
      return(FALSE);
   }

   while(Read(fh,&ed,sizeof(struct Editor)) == sizeof(struct Editor))
   {
      if(ed.number == type)
      {
         Close(fh);
         strcpy(EdName,ed.name);
         return(TRUE);
      }
   }

   Close(fh);
   strcpy(EdName,"None Selected");
   return(FALSE);
}
//-

/// GetProto()
BOOL GetProto(char type, char *ProtoName)
{
   BPTR     fh;
   struct   Protocol proto;

   if(type == 0)
   {
      strcpy(ProtoName,"None Selected");
      return(FALSE);
   }

   fh = Open("DLGConfig:Misc/Protocols.BBS",MODE_OLDFILE);

   if(!fh)
   {
      strcpy(ProtoName,"None Selected");
      return(FALSE);
   }

   while(Read(fh,&proto,sizeof(struct Protocol)) == sizeof(struct Protocol))
   {
      if(proto.letter == type)
      {
         Close(fh);
         strcpy(ProtoName,proto.name);
         return(TRUE);
      }
   }

   Close(fh);
   strcpy(ProtoName,"None Selected");
   return(FALSE);
}
//-

/// GetArchiver()
BOOL GetArchiver(char type, char *ArcName)
{
   BPTR     fh;
   struct   Archiver Arc;

   if(type == 0)
   {
      strcpy(ArcName,"None Selected");
      return(FALSE);
   }

   fh = Open("DLGConfig:Misc/Archivers.BBS",MODE_OLDFILE);

   if(!fh)
   {
      strcpy(ArcName,"None Selected");
      return(FALSE);
   }

   while(Read(fh,&Arc,sizeof(struct Archiver)) == sizeof(struct Archiver))
   {
      if(Arc.number == type)
      {
         Close(fh);
         strcpy(ArcName,Arc.name);
         return(TRUE);
      }
   }

   Close(fh);
   strcpy(ArcName,"None Selected");
   return(FALSE);
}
//-

/// GetMenuSet()
BOOL GetMenuSet(char type, char *MenuName)
{
   BPTR     fh;
   struct   MenuSet  set;

   if(type == 0)
   {
      strcpy(MenuName,"Default");
      return(FALSE);
   }

   fh = Open("DLGConfig:Misc/MenuSets.BBS",MODE_OLDFILE);

   if(!fh)
   {
      strcpy(MenuName,"Default");
      return(FALSE);
   }

   while(Read(fh,&set,sizeof(struct MenuSet)) == sizeof(struct MenuSet))
   {
      if(set.number == type)
      {
         Close(fh);
         strcpy(MenuName,set.name);
         return(TRUE);
      }
   }

   Close(fh);
   strcpy(MenuName,"Default");
   return(FALSE);
}
//-

/// GetCharSet()
BOOL GetCharSet(char type, char *CharName)
{
   BPTR     fh;
   struct   CharSet  set;

   if(type == 0)
   {
      strcpy(CharName,"Default");
      return(FALSE);
   }

   fh = Open("DLGConfig:Charsets/CharSets.BBS",MODE_OLDFILE);

   if(!fh)
   {
      strcpy(CharName,"Default");
      return(FALSE);
   }

   while(Read(fh,&set,sizeof(struct CharSet)) == sizeof(struct CharSet))
   {
      if(set.number == type)
      {
         Close(fh);
         strcpy(CharName,set.name);
         return(TRUE);
      }
   }

   Close(fh);
   strcpy(CharName,"Default");
   return(FALSE);
}
//-

/// SelectEditor()
char SelectEditor(void)
{
   BPTR     fh;
   struct   Editor Ed;


   if(NULL == (fh = Open("DLGConfig:misc/Editors.BBS",MODE_OLDFILE)))
      return(0);


   AFPrintf(&UserDat,sout,"%a6Available Editors%a7\n");
   Draw_Line(UserDat.Screen_Width);

   while(Read(fh,&Ed,sizeof(struct Editor)) == sizeof(struct Editor))
      if(Ed.level <= udat.User_Level)
         AFPrintf(&UserDat,sout,"%a7[%a3%3d%a7]  %a6%s\n",Ed.number, Ed.name);

   AFPrintf(&UserDat,sout,"%a7");
   Draw_Line(UserDat.Screen_Width);

   return((char) IntQuery("Select Editor -> ",1,255,0,&uin));
}
//-

/// SelectProto()
char SelectProto(char *P)
{
   BPTR     fh;
   struct   Protocol Proto;


   if(NULL == (fh = Open("DLGConfig:misc/Protocols.BBS",MODE_OLDFILE)))
      return(0);


   AFPrintf(&UserDat,sout,"%a6Available Protocols%a7\n");
   Draw_Line(UserDat.Screen_Width);
   AFPrintf(&UserDat,sout,"%a3LTR Desc                                      SND REC BAT RES%a7\n");
   Draw_Line(UserDat.Screen_Width);

   while(Read(fh,&Proto,sizeof(struct Protocol)) == sizeof(struct Protocol))
      if(Proto.level <= udat.User_Level)
         AFPrintf(&UserDat,sout,"%a7[%a3%c%a7] %a6%-41.41s %s %s %s %s\n",
                                 Proto.letter,
                                 Proto.name,
                                 (Proto.flags & PROTO_SEND)   ? "YES" : "NO ",
                                 (Proto.flags & PROTO_REC)    ? "YES" : "NO ",
                                 (Proto.flags & PROTO_BATCH)  ? "YES" : "NO ",
                                 (Proto.flags & PROTO_RESUME) ? "YES" : "NO ");

   AFPrintf(&UserDat,sout,"%a7");
   Draw_Line(UserDat.Screen_Width);

   DLGInput("Select Protocol -> ",NULL,P,NULL,1,1,1);
}
//-

/// SelectArc()
char SelectArc(void)
{
   BPTR     fh;
   struct   Archiver Arc;

   if(NULL == (fh = Open("DLGConfig:misc/Archivers.BBS",MODE_OLDFILE)))
      return(0);

   AFPrintf(&UserDat,sout,"%a6Available Archivers%a7\n");
   Draw_Line(UserDat.Screen_Width);
   AFPrintf(&UserDat,sout,"%a3Num     Desc                                    Ext   Efficiency%a7\n");
   Draw_Line(UserDat.Screen_Width);

   while(Read(fh,&Arc,sizeof(struct Archiver)) == sizeof(struct Archiver))
      if(Arc.level <= udat.User_Level)
         AFPrintf(&UserDat,sout,"%a7[%a3%3d%a7]  %a6%-40.40s %-5.5s %3.3d%%\n",
                                 Arc.number, Arc.name, Arc.extension, Arc.compression);

   AFPrintf(&UserDat,sout,"%a7");
   Draw_Line(UserDat.Screen_Width);

   return((char) IntQuery("Select Archiver -> ",1,255,0,&uin));
}
//-

/// SelectMenuSet()
char SelectMenuSet(void)
{
   BPTR     fh;
   struct   MenuSet set;


   if(NULL == (fh = Open("DLGConfig:misc/MenuSets.BBS",MODE_OLDFILE)))
      return(0);


   AFPrintf(&UserDat,sout,"%a6Available Menu Sets%a7\n");
   Draw_Line(UserDat.Screen_Width);

   while(Read(fh,&set,sizeof(struct MenuSet)) == sizeof(struct MenuSet))
      if(set.level <= udat.User_Level)
         AFPrintf(&UserDat,sout,"%a7[%a3%3d%a7]  %a6%s\n",set.number, set.name);

   AFPrintf(&UserDat,sout,"%a7");
   Draw_Line(UserDat.Screen_Width);

   return((char) IntQuery("Select Menu Set -> ",1,127,0,&uin));
}
//-

/// SelectCharSet()
char SelectCharSet(void)
{
   BPTR     fh;
   struct   CharSet set;


   if(NULL == (fh = Open("DLGConfig:CharSets/CharSets.BBS",MODE_OLDFILE)))
      return(0);


   AFPrintf(&UserDat,sout,"%a6Available Character Sets%a7\n");
   Draw_Line(UserDat.Screen_Width);

   while(Read(fh,&set,sizeof(struct CharSet)) == sizeof(struct CharSet))
      if(set.level <= udat.User_Level)
         AFPrintf(&UserDat,sout,"%a7[%a3%3d%a7]  %a6%s\n",set.number, set.name);

   AFPrintf(&UserDat,sout,"%a7");
   Draw_Line(UserDat.Screen_Width);

   return((char) IntQuery("Select Character Set -> ",1,255,0,&uin));
}
//-

/// ChkEditor()
BOOL ChkEditor(char num)
{
   BOOL     OK;
   BPTR     fh;
   struct   Editor Ed;


   if(NULL == (fh = Open("DLGConfig:misc/Editors.BBS",MODE_OLDFILE)))
      return(FALSE);

   while(Read(fh,&Ed,sizeof(struct Editor)) == sizeof(struct Editor))
   {
      if(Ed.number == num)
      {
         if(Ed.level <= udat.User_Level)
            OK = TRUE;
         else
            OK = FALSE;

         Close(fh);
         return(OK);
      }
   }

   Close(fh);
   return(FALSE);
}
//-

/// ChkProto()
BOOL ChkProto(char num)
{
   BOOL     OK;
   BPTR     fh;
   struct   Protocol proto;


   if(NULL == (fh = Open("DLGConfig:misc/Protocols.BBS",MODE_OLDFILE)))
      return(FALSE);

   while(Read(fh,&proto,sizeof(struct Protocol)) == sizeof(struct Protocol))
   {
      if(proto.letter == num)
      {
         if(proto.level <= udat.User_Level)
            OK = TRUE;
         else
            OK = FALSE;

         Close(fh);
         return(OK);
      }
   }

   Close(fh);
   return(FALSE);
}
//-

/// ChkArc()
BOOL ChkArc(char num)
{
   BOOL     OK;
   BPTR     fh;
   struct   Archiver Arc;


   if(NULL == (fh = Open("DLGConfig:misc/Archivers.BBS",MODE_OLDFILE)))
      return(FALSE);

   while(Read(fh,&Arc,sizeof(struct Archiver)) == sizeof(struct Archiver))
   {
      if(Arc.number == num)
      {
         if(Arc.level <= udat.User_Level)
            OK = TRUE;
         else
            OK = FALSE;

         Close(fh);
         return(OK);
      }
   }

   Close(fh);
   return(FALSE);
}
//-

/// ChkMenu()
BOOL ChkMenu(char num)
{
   BOOL     OK;
   BPTR     fh;
   struct   MenuSet Set;


   if(NULL == (fh = Open("DLGConfig:misc/MenuSets.BBS",MODE_OLDFILE)))
      return(FALSE);

   while(Read(fh,&Set,sizeof(struct MenuSet)) == sizeof(struct MenuSet))
   {
      if(Set.number == num)
      {
         if(Set.level <= udat.User_Level)
            OK = TRUE;
         else
            OK = FALSE;

         Close(fh);
         return(OK);
      }
   }

   Close(fh);
   return(FALSE);
}
//-

/// ChkChar()
BOOL ChkChar(char num)
{
   BOOL     OK;
   BPTR     fh;
   struct   CharSet Set;


   if(NULL == (fh = Open("DLGConfig:CharSets/CharSets.BBS",MODE_OLDFILE)))
      return(FALSE);

   while(Read(fh,&Set,sizeof(struct CharSet)) == sizeof(struct CharSet))
   {
      if(Set.number == num)
      {
         if(Set.level <= udat.User_Level)
            OK = TRUE;
         else
            OK = FALSE;

         Close(fh);
         return(OK);
      }
   }

   Close(fh);
   return(FALSE);
}
//-


