#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <dos.h>
#include <exec/types.h>
#include <libraries/dosextens.h>

#include <dlg/dlg.h>
#include <dlg/user.h>

#include <link/io.h>
#include <link/lang.h>

#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/dlg.h>

#include <pragmas/dlg.h>

#include <private/Version.h>
#define  ObjRev "1"
const UBYTE version[]="\0$VER: DFExport " BUILDVER "." ObjRev " " COPYRIGHT " by Digerati Dreams "__AMIGADATE__;


/* Prototypes for functions defined in dfexport.c */
void  main(int , char **);
void  Usage(void);
void _CXBRK(void);


BPTR               sout;
struct USER_DATA   StUser;
struct Ram_File    RUser;
struct NameStruct *users;

struct Library    *DLGBase = NULL;
char             **SA;


VOID main(int argc, char *argv[])

{char  *template = NULL;
 char   filename[80];
 ULONG  filesize;
 SHORT  linelen  = 80;

 struct NameStruct *cuser;
 struct NameStruct *uend;

 sout = Output();
 if (argc < 2)  Usage();

 while(--argc > 0)
      {char *s;

       s = *++argv;
       if (*s++ == '-')
          {while(*s)
                {switch(*s++)
                       {case 'l':
                        case 'L':  if (!--argc)  break;
                                   linelen = atol(*++argv);
                                   break;

                        default:   Usage();
                                   break;
                       }
                }
          }
        else
          {if (!template)
               template = --s;
             else
               Usage();
          }
      }


 if (!(DLGBase = OpenLibrary(DLGNAME, DLGVERSION)))  exit(5);
 if (!(SA = getlang(NULL)))                          exit(5);

 if (FileSize("DLGCONFIG:Misc/Users.bbs", &filesize))
    {AFPrintf(NULL, sout, SA[51]);
    _CXBRK();
    }

 if (!filesize)
    {AFPrintf(NULL, sout, SA[51]);
    _CXBRK();
    }

 if (!(users = malloc(filesize)))
    {AFPrintf(NULL, sout, SA[52]);
    _CXBRK();
    }

 if (GetFirstStruct("DLGCONFIG:Misc/Users.bbs", (char *)users, filesize))
    {AFPrintf(NULL, sout, SA[53]);
    _CXBRK();
    }

 uend = (struct NameStruct *)((char *)users + filesize);
 for(cuser = users; cuser < uend; cuser++)
    {__chkabort();

     ASPrintf(NULL, filename, "USER:%s/User.Data", cuser->name);
     UnderScore(filename);

     if (!GetFirstStruct(filename, (char *)&StUser, sizeof(struct USER_DATA)))
        {strcpy(RUser.Name, cuser->name);
         Capitalize(RUser.Name);

         StUser.Screen_Width = linelen;
         StUser.Ansi_Flag    = 0;
         StUser.More_Flag    = 0;
         DispForm(template, &StUser, &StUser, &RUser, "NOL");
        }
    }

 AFPrintf(NULL, sout, SA[54], filesize / sizeof(struct NameStruct));
_CXBRK();
}


void Usage()

{Write(sout, "\n Usage: DFExport <templatefilename> [-L <linesize>]",                        52);
 Write(sout, "\n        linesize = Maximum Width of line before wrapping (0=unlimited)\n\n", 73);
 exit(5);
}


void _CXBRK()

{CloseLibrary(DLGBase);
 if (users) free(users);
 exit(0);
}
