#include "SysUser.h"

#include <link/io.h>
#include <link/user.h>

int Validate_Users(void)
{
   long zflag;
   char inp[10],quitflag=0,name[36];
   int oldlevel;

   while(1)
   {
      BPTR fp;
      char filename[128];

      if(quitflag)
         break;

      if(ReadChar(0) == 3)
      {
         AFPrintf(NULL,sout,SA[2084]);
         return(1);
      }

      if(GetFirstStruct("DLGCONFIG:Misc/NewUser.bbs",name,36)==-1)
      {
         AFPrintf(NULL,sout,SA[2108]);
         break;
      }

      ASPrintf(NULL,filename,"USER:%s/User.Data",name);
      UnderScore(filename);

      if((fp=Open(filename,MODE_OLDFILE))==EOF)
      {
         DeleteStruct("DLGCONFIG:Misc/NewUser.bbs",name,36,36);  
         continue;
      }
    
      Read(fp,&User,sizeof(User));
      Close(fp);
      
      Clr(UserDat.Ansi_Flag);
      Print_User(name);

      DLGInput(NULL,inp,NULL,1,10,1, SA[2109]);
      
      Clr(UserDat.Ansi_Flag);
    
      switch(inp[0])
      {
         case 0:
                  DeleteStruct("DLGCONFIG:Misc/NewUser.bbs",name,36,36);
                  AddStruct("T:TempUser",name,36,36);     
                  break;

         case 'V':
                  oldlevel=User.User_Level;
                  
                  if(RawValidate(&User,1))
                     break;
      
                  if(!AddStruct(filename,(char *)&User,sizeof(User),36))
                     AFPrintf(NULL,sout,SA[2110]);
                  
                  Inform(name,SA[2111],Ext,0);
                  DeleteStruct("DLGCONFIG:Misc/NewUser.bbs",name,36,36);
      
                  if(Exists("DLGConfig:batch/ValidatedUser.batch"))
                  {
                     UnderScore(name);
                     ASPrintf(NULL,filename,"Execute DLGConfig:batch/ValidatedUser.batch %s %d %d",name,oldlevel,User.User_Level);
                     DeScore(name);
                     Execute(filename,0L,0L);
                  }
                  
                  AFPrintf(NULL,sout,SA[2112]);
                  AddGlobalAreas(name,oldlevel,User.User_Level,0|128,"MSG:Area.bbs");
                  AddGlobalAreas(name,oldlevel,User.User_Level,1|128,"FILE:Area.bbs");
                  AFPrintf(NULL,sout,SA[2092]);
                  break;
         
         case 'D':
                  zflag=finput(0, SA[2113]);
                  AFPrintf(NULL,sout,"\n\n");
      
                  if(!zflag)
                     break;
               
                  Delete_User(name,1);
                  break;
    
         case 'E':
                  oldlevel=User.User_Level;
                  
                  if(RawValidate(&User,1))
                     break;
      
                  if(!AddStruct(filename,(char *)&User,sizeof(User),36))
                     AFPrintf(NULL,sout,SA[2110]);
      
                  Inform(name,SA[2111],Ext,0);
                  DeleteStruct("DLGCONFIG:Misc/NewUser.bbs",name,36,36);
      
                  if(Exists("DLGConfig:batch/ValidatedUser.batch"))
                  {
                     UnderScore(name);
                     ASPrintf(NULL,filename,"Execute DLGConfig:batch/ValidatedUser.batch %s %d %d",name,oldlevel,User.User_Level);
                     DeScore(name);
                     Execute(filename,0L,0L);
                  }
      
                  AFPrintf(NULL,sout,SA[2114]);
                  Edit_User(name);
                  AFPrintf(NULL,sout,SA[2112]);
                  AddGlobalAreas(name,oldlevel,User.User_Level,0|128,"MSG:Area.bbs");
                  AddGlobalAreas(name,oldlevel,User.User_Level,1|128,"FILE:Area.bbs");
                  AFPrintf(NULL,sout,SA[2092]);
                  break;
    
         case 'Q':
                  quitflag=1;
                  break;
      }
   }
  
   while(GetFirstStruct("T:TempUser",name,36)!=-1)
   {
      AddStruct("DLGCONFIG:Misc/NewUser.bbs",name,36,36);
      DeleteStruct("T:TempUser",name,36,36);
   }
  
   AFPrintf(NULL,sout,"\n");
}


int RawValidate(struct USER_DATA *user,char mode)
{
   char name[36],filename[80];
   struct USER_DATA valuser;

   if(!INSTACK)
      AFPrintf(NULL,sout,SA[2115]);
   
   if(!SelectTemplate(name))
      return(-1);
  
   ASPrintf(NULL,filename,"Dlgconfig:Template/%s.template",name);
   UnderScore(filename);
  
   if(GetFirstStruct(filename,(char *)&valuser,sizeof(valuser)))
      return(-1);
  
   UpdateData(user,&valuser,mode);
   return(0);
}


