#include "SysUser.h"

#include <link/io.h>
#include <link/user.h>

/// AddTemplate
int AddTemplate(void)
{
   long zflag;
   char filename[49];
   char UserName[36];
   struct USER_DATA User;

   while(1)
   {
      zflag=DLGInput(NULL,UserName,NULL,20,20,3, SA[2254]);
      AFPrintf(NULL,sout,"\n");
    
      if(!zflag)
      {
         AFPrintf(NULL,sout,SA[2255]);
         return(-1);
      }
    
      if(!GetStruct("Dlgconfig:Template/Template",UserName,36,36))
      {
         AFPrintf(NULL,sout,SA[2256]);
      }
      else
      {
         break;
      }
   }

   if(New_User(UserName,&User,2))
   {
      AFPrintf(NULL,sout,SA[2095]);
      return(-1);
   }

   Upper(UserName);
   ASPrintf(NULL,filename,"DLGCONFIG:Template/%s.template",UserName);
   UnderScore(filename);
   Capitalize(filename);
   DeleteFile(filename);
  
   if(AddStruct(filename,(char *)&User,sizeof(User),1))
   {
      AFPrintf(NULL,sout,SA[2257],filename);
      return(-1);
   }
  
   AFPrintf(NULL,sout,SA[2258]);
   AddStruct("DLGCONFIG:template/template",UserName,36,36);
   return(0);
}
//-

#define QUIET     1
#define VERBOSE   0

/// ListTemplates
int ListTemplates(char mode)
{
   BPTR fp;
   int counter=0;
   char name[36];

   if((fp=Open("DLGCONFIG:template/template",MODE_OLDFILE))==EOF)
      return(0);
  
   if(mode==VERBOSE)
      Draw_Line(40);
  
   while(Read(fp,name,36)==36)
   {
      counter++;
    
      if(mode==VERBOSE)
         AFPrintf(NULL,sout,SA[2259],counter,name);
   }
   
   Close(fp);
  
   if(mode==VERBOSE)
   {
      Draw_Line(40);
      AFPrintf(NULL,sout,"\n");
   }
  
   return(counter);
}
//-

int SelectTemplate(char *name)
{
   int number,max;
   BPTR fp;

   if(!(max=ListTemplates((INSTACK)?QUIET:VERBOSE)))
      return(0);
    
   number=iinput(1,max,0, SA[2260]);
   AFPrintf(NULL,sout,"\n\n");
  
   if(!number)
      return(0);
  
   if((fp=Open("Dlgconfig:template/template",MODE_OLDFILE))==EOF)
      return(0);
  
   number--;
  
   Seek(fp,(long)(number*36),OFFSET_BEGINNING);
   Read(fp,name,36);
   Close(fp);
  
   return(number+1);
}


int EditTemplate()
{
   char name[36],filename[80];
   struct USER_DATA User;
   int inpval;
   char string[80];

   if(!SelectTemplate(name))
   {
      AFPrintf(NULL,sout,SA[2255]);
      return(-1);
   }
  
   ASPrintf(NULL,filename,"Dlgconfig:template/%s.template",name);
   UnderScore(filename);
   
   if(GetFirstStruct(filename,(char *)&User,sizeof(User)))
   {
      AFPrintf(NULL,sout,SA[2261],filename);
      return(-1);
   }
  
   while(1)
   {
      if(!INSTACK) DisplayTemplate(name,&User);
      inpval=iinput(1,12,0, SA[2190]);
      Clr(UserDat.Ansi_Flag);
      
      switch(inpval)
      {
         case 1:
                  User.User_Level = iinput(0,255,User.User_Level, SA[2206]);
                  AFPrintf(NULL,sout,"\n\n");
                  break;
    
         case 2:
                  User.Ratio=iinput(0,99,User.Ratio, SA[2226]);
                  AFPrintf(NULL,sout,"\n\n");
                  break;
    
         case 3:
                  User.Pop_Screen=((User.Pop_Screen+1)&1);
                  AFPrintf(NULL,sout,"\n\n");
                  break;
    
         case 4:
                  User.Bulletin_Access=((User.Bulletin_Access+1)&1);
                  break;
    
         case 5:
                  User.Daily_Limit = iinput(1,1440,User.Daily_Limit, SA[2209]);
                  AFPrintf(NULL,sout,"\n\n");
                  break;
    
         case 6:
                  User.Session_Limit = iinput(0,1440,User.Session_Limit, SA[2211]);
                  AFPrintf(NULL,sout,"\n\n");
                  break;
    
         case 7:
                  DLGInput(NULL,string,NULL,8,8,0, SA[2216]);
                  User.Bytes_Uploaded=atol(string)*1024L;
                  AFPrintf(NULL,sout,"\n\n");
                  break;
    
         case 8:
                  DLGInput(NULL,string,NULL,8,8,0, SA[2221]);
                  User.Bytes_Downloaded=atol(string)*1024L;
                  AFPrintf(NULL,sout,"\n\n");
                  break;
    
         case 9:
                  DLGInput(NULL,string,NULL,1,1,1, SA[2219]);
                  AFPrintf(NULL,sout,"\n\n");
                  
                  if(string[0]=='C')
                  {
                     User.UUCP=1;
                  }
                  else
                  {
                     if(string[0]=='W')
                     {
                        User.UUCP=2;
                     }
                     else
                     {
                        User.UUCP=0;
                     }
                  }
      
                  break;
    
         case 10:
                  User.DirLimit = iinput(0,30000,User.DirLimit, SA[2217]);
                  AFPrintf(NULL,sout,"\n\n");
                  break;
    
         case 11:
                  User.credit=iinput(0,32000,User.credit, SA[2227]);
                  AFPrintf(NULL,sout,"\n\n");
                  break;
    
         case 12:
                  User.NetMail=0;
                  
                  if(finput(1, SA[2234]))
                     User.NetMail+=1;
                  
                  AFPrintf(NULL,sout,"\n\n");
      
                  if(finput(1, SA[2235]))
                     User.NetMail+=2;
      
                  AFPrintf(NULL,sout,"\n\n");
                  break;
    
         case 0:
                  DeleteFile(filename);
      
                  if(!AddStruct(filename,(char *)&User,sizeof(User),1))
                     AFPrintf(NULL,sout,SA[2262]);
      
                  return(0);
                  break;
      }
   }
}


void DisplayTemplate(char *name,struct USER_DATA *user)
{
   AFPrintf(NULL,sout,SA[2263],name);
   AFPrintf(NULL,sout,SA[2264],user->User_Level);
   AFPrintf(NULL,sout,SA[2265]);
  
   if(!user->Ratio)
   {
      AFPrintf(NULL,sout,SA[2266]);
   }
   else
   {
      AFPrintf(NULL,sout,SA[2267],user->Ratio);
   }
  
   AFPrintf(NULL,sout,SA[2268],(user->Pop_Screen)?SA[2248]:SA[2249]);
   AFPrintf(NULL,sout,SA[2269],(user->Bulletin_Access)?SA[2248]:SA[2249]);
   AFPrintf(NULL,sout,SA[2270],user->Daily_Limit);
   AFPrintf(NULL,sout,SA[2271],user->Session_Limit);
   AFPrintf(NULL,sout,SA[2272],user->Bytes_Uploaded/1024L);
   AFPrintf(NULL,sout,SA[2273],user->Bytes_Downloaded/1024L);
   AFPrintf(NULL,sout,SA[2274]);
  
   switch(user->UUCP)
   {
      case 0:
               AFPrintf(NULL,sout,SA[2275]);
               break;
  
      case 1:
               AFPrintf(NULL,sout,SA[2276]);
               break;
      
      case 2:
               AFPrintf(NULL,sout,SA[2277]);
               break;
   }
  
   AFPrintf(NULL,sout,"\n");
   AFPrintf(NULL,sout,SA[2278],user->DirLimit);
   AFPrintf(NULL,sout,SA[2279],user->credit);
   AFPrintf(NULL,sout,SA[2280],(user->NetMail&1)?SA[2281]:SA[2282],(user->NetMail&2)?SA[2283]:SA[2282]);
}


int DeleteTemplate(void)
{
   long zflag;
   char name[36];
   char filename[80];

   if(!SelectTemplate(name))
   {
      AFPrintf(NULL,sout,SA[2255]);
      return(-1);
   }
  
   ASPrintf(NULL,filename,"Dlgconfig:template/%s.template",name);
   UnderScore(filename);
   zflag=finput(1, SA[2284]);
   AFPrintf(NULL,sout,"\n\n");
   
   if(!zflag)
   {
      AFPrintf(NULL,sout,SA[2255]);
      return(-1);
   }
  
   DeleteFile(filename);
   DeleteStruct("Dlgconfig:template/template",name,36,36);
   AFPrintf(NULL,sout,SA[2285]);
   return(0);
}


int GlobalTemplate(void)
{
   char               inp     [2];
   char               name    [36];
   char               filename[256];
   char               batchflag;
   char               tflag;

   struct USER_DATA   valuser;
   struct NameStruct *garray;

   int                offset;
   int                oldlevel;
   int                numusers;
   int                counter;

   if (!INSTACK)
      AFPrintf(NULL,sout,SA[2115]);
   
   if (!SelectTemplate(name))
      return(-1);

   ASPrintf(NULL,filename, "DLGConfig:Template/%s.template", name);
   UnderScore(filename);
   
   if (GetFirstStruct(filename, (char *)&valuser, sizeof(valuser)))
      return(-1);

   tflag=finput(1, SA[2241]);
   AFPrintf(NULL,sout,"\n\n");

   batchflag = Exists("DLGConfig:batch/AppliedTemplate.batch");

   menu(GlobalMenu,5,0);
   AFPrintf(NULL,sout,"\n");
   DLGInput(NULL,inp,NULL,1,1,1, SA[2286]);
   AFPrintf(NULL,sout,"\n\n");

   switch(inp[0])
   {
      case 'L':
               {
                  int              lower;
                  int              upper;
                  int              counter;
                  struct USER_DATA user;

                  lower = iinput(1,255,0, SA[2287]);
                  AFPrintf(NULL,sout,"\n\n");
         
                  if (!lower)
                     return(FALSE);

                  upper = iinput(1,255,0, SA[2288]);
                  AFPrintf(NULL,sout,"\n\n");
         
                  if (!upper)
                     return(FALSE);

                  numusers = 0;

                  if (!(garray=(struct NameStruct *)malloc((long)NumUsers*36L)))
                  {
                     AFPrintf(NULL,sout,SA[2289]);
                     return(FALSE);
                  }
  
                  AFPrintf(NULL,sout,SA[2290]);
         
                  for(counter=0;counter<NumUsers;counter++)
                  {
                     ASPrintf(NULL,filename,"USER:%s/User.data",(users+counter)->name);
                     UnderScore(filename);

                     if (GetFirstStruct(filename,(char *)&user,sizeof(user))==-1)
                        continue;
            
                     if (user.User_Level<lower || user.User_Level>upper)
                        continue;
            
                     movmem(users+counter, garray+numusers, 36);
                     numusers++;
                  }

                  AFPrintf(NULL,sout,SA[2092]);
               }
         
               break;
      
      case 'A':
               garray   = users;
               numusers = NumUsers;
               break;

      case 'F':
               {
                  ULONG size;
                  BPTR fp;

                  DLGInput(NULL, filename, NULL, 127, 127, 0, SA[2291]);
                  AFPrintf(NULL,sout,"\n\n");

                  if (FileSize(filename, &size)==-1)
                  {
                     AFPrintf(NULL,sout,SA[2292]);
                     return(FALSE);
                  }

                  if (!(garray=(struct NameStruct *)malloc((long)NumUsers*36L)))
                  {
                     AFPrintf(NULL,sout,SA[2289]);
                     return(FALSE);
                  }

                  if ((fp=Open(filename,MODE_OLDFILE))==NULL)
                  {
                     AFPrintf(NULL,sout,SA[2293],filename);
                     return(FALSE);
                  }

                  numusers = 0;
                  
                  while(FGets(fp, name, 36))
                  {
                     strcpy((garray+numusers)->name, name);
                     
                     if (CheckUser(name)!=1)
                        continue;
                     
                     numusers++;
                  }
                  
                  Close(fp);
               }
               
               break;
      
      case 'G':
               {
                  struct Group_Def Group;
                  ULONG            size;

                  if (!INSTACK)
                     List_Groups();
                  
                  if (!(DLGInput(NULL,Group.name,NULL,36,36,3, SA[2294])))
                  {
                     AFPrintf(NULL,sout,SA[2080]);
                     return(FALSE);
                  }
                  
                  AFPrintf(NULL,sout,"\n\n");

                  if (GetStruct("DLGCONFIG:Group/Group.bbs",(char *)&Group,sizeof(Group),36)==-1)
                  {
                     AFPrintf(NULL,sout,SA[2295]);
                     return(FALSE);
                  }

                  ASPrintf(NULL,filename,"DLGCONFIG:Group/%s.Group",Group.name);
                  
                  if (FileSize(filename,&size)==-1)
                  {
                     AFPrintf(NULL,sout,SA[2296],filename);
                     return(FALSE);
                  }

                  if (!(garray=(struct NameStruct *)malloc(size)))
                  {
                     AFPrintf(NULL,sout,SA[2289]);
                     return(FALSE);
                  }

                  if (GetFirstStruct(filename,(char *)garray,(int)size)==-1)
                  {
                     AFPrintf(NULL,sout,SA[2297]);
                     return(FALSE);
                  }

                  numusers = size / 36;
               }
               break;

      case 'E':
               if (!(garray=(struct NameStruct *)malloc((long)NumUsers*36L)))
               {
                  AFPrintf(NULL,sout,SA[2289]);
                  return(FALSE);
               }

               numusers = 0;
               
               while(DLGInput((char *)users, name, (char *)-1L, 36, NumUsers, 6, SA[2093]))
               {
                  if (name[0]=='\0')
                  {
                     AFPrintf(NULL,sout,"\n\n");
                     break;
                  }
                  
                  if (CheckUser(name)!=1)
                  {
                     AFPrintf(NULL,sout,SA[2298]);
                     continue;
                  }

                  AFPrintf(NULL,sout,"\n");
                  strcpy((garray+numusers)->name, name);
                  numusers++;
                  
                  if (numusers==NumUsers)
                     break;
               }
               
               break;

        default:
               AFPrintf(NULL,sout,SA[2255]);  
               return(FALSE);
               break;
   }

   AFPrintf(NULL,sout,SA[2299]);
   AFPrintf(NULL,sout,SA[2300]);
 
   for(counter=0; counter < numusers; counter++)
   {
      AFPrintf(NULL,sout,"%s\n",(garray+counter)->name);
   }

   AFPrintf(NULL,sout,SA[2301]);

   if (!(finput(0, SA[2302])))
   {
      AFPrintf(NULL,sout,"\n\n");
     
      if (garray)
         free(garray);
      
      return(FALSE);
   }
 
   AFPrintf(NULL,sout,"\n\n");

   offset = 0;
 
   while(offset < numusers)
   {
      strcpy(name, (garray+offset)->name);

      AFPrintf(NULL,sout,SA[2303], name);
      
      if (SRead_User(name))
      {
         AFPrintf(NULL,sout,SA[2304]);
         continue;
      }
      
      oldlevel = User.User_Level;
      UpdateData(&User, &valuser, (tflag+1)&1);

      AFPrintf(NULL,sout,SA[2305]);
      AddGlobalAreas(name, oldlevel, User.User_Level, 0|128, "MSG:Area.bbs");
      AddGlobalAreas(name, oldlevel, User.User_Level, 1|128, "FILE:Area.bbs");
      WriteUser(name, &User);

      if (batchflag)
      {
         UnderScore(name);
         ASPrintf(NULL,filename,"Execute DLGConfig:batch/AppliedTemplate.batch %s %d %d",name,oldlevel,User.User_Level);
         Execute(filename, 0L, 0L);
      }

      AFPrintf(NULL,sout,SA[2089]);
      offset++;
   }

   AFPrintf(NULL,sout,"\n");
 
   if (garray)  free(garray);
}


