#include "SysUser.h"

#include <link/io.h>
#include <link/user.h>

/// Edit_Search_Areas
void Edit_Search_Areas(char *name, char mode)
{
   USHORT   a;
   USHORT   b;
 
   char  c[2];
   char  breakflag;

   if (mode == 1)
   {
      strcpy(areafile, "FILE:Area.bbs");
   }
   else
   {
      strcpy(areafile, "MSG:Area.bbs");
   }

   Read_Search_Areas(name, mode);

   while(TRUE)
   {
      breakflag = 0;
      
      AFPrintf(&UserDat, sout, SA[2310]);
      
      if (!INSTACK)
      {
         List_Search_Areas(mode);
         OneLine();
      }

      menu(AreaMenu,7,0);
      
      DLGInput(NULL,c,NULL,1,1,1, SA[2311]);
      
      TwoLines();

      switch(c[0])
      {
         case 'A':
                  while(TRUE)
                  {
                     b = iinput(1,9999,0, SA[2312]);
                     
                     TwoLines();
                     
                     if (!b)
                        break;
                     
                     if (Area_Clearance(b, name, mode))
                     {
                        AFPrintf(&UserDat, sout, SA[2313]);
                        continue;
                     }

                     for(a = 0; a < HighSearchArea; a++)
                     {
                        if (SearchArea[a] == b)
                           breakflag = 1;
                     }
                        
                     if (breakflag == 1)
                     {
                        breakflag = 0;
                        AFPrintf(&UserDat, sout, SA[2314]);
                        continue;
                     }

                     SearchArea[HighSearchArea]=b;
                     HighSearchArea++;
                  }
                  
                  break;

         case 'L':
                  ListAreas(name, &User, (mode==1)?mode:0, Sig.number);
                  OneLine();
                  Pause();
                  break;

         case 'R':
                  while(TRUE)
                  {
                     b = iinput(1,9999,0, SA[2315]);
                     
                     if (!b)
                     {
                        TwoLines();
                        break;
                     }

                     for(a = 0; b!=SearchArea[a] && a<HighSearchArea; a++);
                     {
                        if (a==HighSearchArea) 
                        {
                           AFPrintf(&UserDat, sout, SA[2316]);
                           continue;
                        }
                     }
                     
                     AFPrintf(&UserDat, sout, SA[2317]);
 
                     for( ; a < HighSearchArea ; a++)
                     {
                        SearchArea[a] = SearchArea[a+1];
                     }
                     
                     HighSearchArea--;
                  }
                  
                  break;

         case 'Q':
                  qsort(SearchArea,HighSearchArea,2,SortSearchArea);
                  break;

         case 'J':
                  Write_Search_Areas(name, mode);
                  AddGlobalAreas(name, 0, User.User_Level, mode+128, areafile);
                  Read_Search_Areas(name, mode);
                  break;

         case 'D':
                  c[1]=finput(1, SA[2318]);
                  TwoLines();
                  
                  if (c[1])
                  {
                     if (!Sig.number)
                     {
                        HighSearchArea=0;
                     }
                     else
                     {
                        DeleteGlobalAreas();
                     }
                  }
                  
                  break;

         case 'S':
                  SelectSIG((mode==1)?mode:0);
                  break;

         case 0:
                  Write_Search_Areas(name, mode);
                  return;
                  break;
      }
   }
}
//-

/// List_Search_Areas
void List_Search_Areas(char mode)
{
   USHORT   a;
   SHORT    poscounter=0;

   AFPrintf(&UserDat, sout, SA[2319]);
 
   for(a = 0; a < HighSearchArea; a++)
   {
      if (Sig.number && !InsureArea(SearchArea[a],mode))
         continue;
     
      AFPrintf(NULL, sout, SA[2320], SearchArea[a]);
      poscounter++;
     
      if (poscounter+1 >= ((UserDat.Screen_Width-20)/5) && a!=(HighSearchArea-1))
      {
         AFPrintf(&UserDat, sout, SA[2321]);
         poscounter = 0;
      }
   }

   if (poscounter     != 0)
      OneLine();
 
   if (HighSearchArea == 0)  
      OneLine();
}
//-

/// Read_Search_Areas
void Read_Search_Areas(char *name, char mode)
{
   BPTR  fp;
 
   USHORT buffer;
 
   char  filename[80];

   HighSearchArea = 0;

   if (!mode)
   {
      ASPrintf(NULL, filename,"User:%s/GlobalAreas.msg", name);
   }
   else
   {
      if (mode==1)
      {
         ASPrintf(NULL, filename,"User:%s/GlobalAreas.file", name);
      }
      else
      {
         ASPrintf(NULL, filename,"User:%s/GlobalAreas.archive", name);
      }
   }
 
   UnderScore(filename);
 
   if ((fp = Open(filename,MODE_OLDFILE)) == EOF)  
      return;

   while(((Read(fp,&buffer,sizeof(buffer))) == sizeof(buffer)))
   {
      SearchArea[HighSearchArea] = buffer;
      HighSearchArea++;
   }
 
   Close(fp);

   return;
}
//-

/// Write_Search_Areas
void Write_Search_Areas(char *name, char mode)
{
   BPTR fp;
 
   USHORT   a;
   USHORT   buffer;
 
   char  filename[255];

   if (!mode)
   {
      ASPrintf(NULL, filename,"User:%s/GlobalAreas.msg", name);
   }
   else
   {
      if (mode==1)
      {
         ASPrintf(NULL, filename,"User:%s/GlobalAreas.file", name); 
      }
      else
      {
         ASPrintf(NULL, filename,"User:%s/GlobalAreas.archive", name); 
      }
   }

   UnderScore(filename);
   DeleteFile(filename);
 
   if ((fp = Open(filename,MODE_READWRITE)) == EOF)
   {
      AFPrintf(&UserDat, sout, SA[2322]);
      return;
   }

   for(a = 0 ; a < HighSearchArea ; a++)
   {
      buffer = SearchArea[a];
      Write(fp,&buffer,sizeof(buffer));
   }

   Close(fp);
 
   return;
}
//-

int SortSearchArea(USHORT *area1, USHORT *area2)
{
   return(*area1-*area2);
}

