#include <exec/types.h>
#include <stdlib.h>
#include <string.h>

#include <dlg/msg.h>
#include <dlg/ANSI.h>
#include <dlg/User.h>
#include <dlg/misc.h>
#include <dlg/file.h>

#include <link/io.h>
#include <link/config.h>

#include <proto/dlg.h>
#include <proto/dos.h>

#include <pragmas/dlg.h>

extern   BPTR                 sout;

extern   int                  AreaType;

extern   struct   Library    *DLGBase;
extern   struct   USER_DATA   UserDat;

extern   int   Create_Array(char **);
extern   void  List_Templates(void);
extern   void  Set_Auto_Access(struct Msg_Area_Template *);
extern   void  Set_Write_Access(struct Msg_Area_Template *);
extern   void  Set_Kill_Access(struct Msg_Area_Template *);
extern   void  Set_Forward_Access(struct Msg_Area_Template *);
extern   void  Set_Copy_Access(struct Msg_Area_Template *);
extern   void  Set_Edit_Access(struct Msg_Area_Template *);
extern   void  Set_Sysop_Access(struct Msg_Area_Template *);
extern   BOOL  Save_Template(struct Msg_Area_Template *, char *);
extern   BOOL  IsAreaValid( SHORT );

static   char  pr[256];

void Show_Template(struct Msg_Area_Template plate, char *Name);
void Get_Charset_Name(char Set, char *Name);

void Change_Auto_Access(struct Msg_Area_Template *);
BOOL Change_Echo_Area_Flag(struct Msg_Area_Template *);
void Change_SeenBy_Flag(struct Msg_Area_Template *);
BOOL Change_Origin(struct Msg_Area_Template *);
BOOL Change_Netmail_Area_Flag(struct Msg_Area_Template *);
BOOL Change_Newsgroup_Flag(struct Msg_Area_Template *);
void Change_Alias_Flag(struct Msg_Area_Template *);
void Change_Signature_Flag(struct Msg_Area_Template *);
BOOL Change_Translator(struct Msg_Area_Template *);
BOOL Change_Capacity(struct Msg_Area_Template *);
BOOL Change_Renumber(struct Msg_Area_Template *);
BOOL Change_Charset(struct Msg_Area_Template *);
void Change_Freq_Area_Flag(struct Msg_Area_Template *);
void Change_Temp_Download_Flag(struct Msg_Area_Template *);
void Change_Validation_Flag(struct Msg_Area_Template *);

/// Edit_Template
void  Edit_Template(void)
{
   char                      *Array       =  NULL;
   char                       Source[36];
   char                       TemplateFileName[256];
   int                        Entries;
   struct   Msg_Area_Template plate;

   Entries = Create_Array(&Array);

   if(Entries == 0) return;

   List_Templates();

   DLGInput(Array,Source,0,36,Entries,6, "Edit which template? %a7-> ");
   TwoLines();

   ASPrintf(NULL,TemplateFileName,"DLGConfig:Template/%s%s",Source,(AreaType ? ".file" : ".msg"));

   if(0 == GetFirstStruct(TemplateFileName,(char *)&plate,sizeof(struct Msg_Area_Template)))
   {
      BOOL  Changed  =  FALSE;
      LONG  action;

      Show_Template(plate, Source);

      while(action = iinput(1,23,0, "Select an item to edit (RETURN to exit and save) %a7-> "))
      {
         OneLine();

         switch(action)
         {
            case  1:  Changed = TRUE; Change_Auto_Access(&plate); break;
            case  2:  Changed = TRUE; OneLine(); Set_Auto_Access(&plate); break;
            case  3:  Changed = TRUE; OneLine(); Set_Write_Access(&plate); break;
            case  4:  Changed = TRUE; OneLine(); Set_Kill_Access(&plate); break;
            case  5:  Changed = TRUE; OneLine(); Set_Forward_Access(&plate); break;
            case  6:  Changed = TRUE; OneLine(); Set_Copy_Access(&plate); break;
            case  7:  Changed = TRUE; OneLine(); Set_Edit_Access(&plate); break;
            case  8:  Changed = TRUE; OneLine(); Set_Sysop_Access(&plate); break;
            case  9:  OneLine(); Changed |= Change_Echo_Area_Flag(&plate); break;
            case 10:  Changed = TRUE; OneLine(); Change_SeenBy_Flag(&plate); break;
            case 11:  OneLine(); Changed |= Change_Origin(&plate); break;
            case 12:  OneLine(); Changed |= Change_Netmail_Area_Flag(&plate); break;
            case 13:  OneLine(); Changed |= Change_Newsgroup_Flag(&plate); break;
            case 15:  Changed = TRUE; OneLine(); Change_Alias_Flag(&plate); break;
            case 16:  Changed = TRUE; OneLine(); Change_Signature_Flag(&plate); break;
            case 17:  OneLine(); Changed |= Change_Translator(&plate); break;
            case 18:  OneLine(); Changed = TRUE; Change_Freq_Area_Flag(&plate); break;
            case 19:  OneLine(); Changed = TRUE; Change_Temp_Download_Flag(&plate); break;
            case 20:  OneLine(); Changed = TRUE; Change_Validation_Flag(&plate); break;
            case 21:  OneLine(); Changed |= Change_Capacity(&plate); break;
            case 22:  OneLine(); Changed |= Change_Renumber(&plate); break;
            case 23:  OneLine(); Changed |= Change_Charset(&plate); break;
         }

         Show_Template(plate,Source);
      }

      TwoLines();

      if(Changed)
      {
         AFPrintf(&UserDat,sout,"Saving ... ");

         if(Save_Template(&plate,TemplateFileName))
            AFPrintf(&UserDat,sout,"Done.\n\n");
      }

   }
   else
   {
      AFPrintf(&UserDat,sout,"Edit_Template(): Error loading template %s\n\n",Source);
   }

   if(Array)   free(Array);
   return;
}
//-

/// Show_Template
void Show_Template(struct Msg_Area_Template plate, char *Name)
{
   char charset[13];

   Clr(UserDat.Ansi_Flag);

   OneLine();
   AFPrintf(&UserDat,sout,CYN "%s Template " YEL " %s" WHT "\n",(AreaType ? "File" : "Message"),Name);
   Draw_Line(UserDat.Screen_Width);
   OneLine();

   AFPrintf(&UserDat,sout,MAG "[" CYN " 1" MAG "]" WHT "          Auto Access: " YEL "%s\n", ((plate.Flag & AUTO_ACCESS_AREA) ? "Yes" : "No"));

   if(plate.Flag & AUTO_ACCESS_AREA)
      AFPrintf(&UserDat,sout,MAG "[" CYN " 2" MAG "]" WHT "    Auto Access Level: " CYN "Lower: " YEL "%3ld  " CYN "Upper: " YEL "%3ld\n",plate.llevel, plate.ulevel);

   AFPrintf(&UserDat,sout,MAG "[" CYN " 3" MAG "]" WHT "%14.14s Access: " CYN "Lower: " YEL "%3ld  " CYN "Upper: " YEL "%3ld\n",(AreaType ? "Upload" : "Write"),plate.lwrite, plate.uwrite);

   AFPrintf(&UserDat,sout,MAG "[" CYN " 4" MAG "]" WHT "          Kill Access: " CYN "Lower: " YEL "%3ld  " CYN "Upper: " YEL "%3ld\n",plate.lkill, plate.ukill);
   AFPrintf(&UserDat,sout,MAG "[" CYN " 5" MAG "]" WHT "%14.14s Access: " CYN "Lower: " YEL "%3ld  " CYN "Upper: " YEL "%3ld\n",(AreaType ? "Download" : "Forward"), plate.lforward, plate.uforward);
   AFPrintf(&UserDat,sout,MAG "[" CYN " 6" MAG "]" WHT "%14.14s Access: " CYN "Lower: " YEL "%3ld  " CYN "Upper: " YEL "%3ld\n",(AreaType ? "Transfer" : "Copy/Move"),plate.lcopy, plate.ucopy);

   if(AreaType == 0)
      AFPrintf(&UserDat,sout,MAG "[" CYN " 7" MAG "]" WHT "          Edit Access: " CYN "Lower: " YEL "%3ld  " CYN "Upper: " YEL "%3ld\n",plate.ledit, plate.uedit);

   AFPrintf(&UserDat,sout,MAG "[" CYN " 8" MAG "]" WHT "         Sysop Access: " CYN "Lower: " YEL "%3ld  " CYN "Upper: " YEL "%3ld\n",plate.lsysop, plate.usysop);

   OneLine();

/// msg only -- echo area, newsgroup, netmail.
   if(AreaType == 0)
   {
      AFPrintf(&UserDat,sout,MAG "[" CYN " 9" MAG "]" WHT "            Echo Area: " YEL "%s\n", ((plate.Flag & ECHO_AREA) ? "Yes" : "No"));

      if(plate.Flag & ECHO_AREA)
      {
         AFPrintf(&UserDat,sout,MAG "[" CYN "10" MAG "]" WHT "       Hide Seen-By's: " YEL "%s\n", ((plate.Flag & HIDE_SEENBY) ? "Yes" : "No"));
         AFPrintf(&UserDat,sout,MAG "[" CYN "11" MAG "]" WHT "          Origin Line: " YEL "%s\n", ((strlen(plate.origin) > 0) ? plate.origin : "DEFAULT"));
         OneLine();
      }

      AFPrintf(&UserDat,sout,MAG "[" CYN "12" MAG "]" WHT "         Netmail Area: " YEL "%s\n", ((plate.Flag & NETMAIL_AREA) ? "Yes" : "No"));
      AFPrintf(&UserDat,sout,MAG "[" CYN "13" MAG "]" WHT "            Newsgroup: " YEL "%s\n", ((plate.Flag & NEWSGROUP_AREA) ? "Yes" : "No"));
      OneLine();
   }
//-

   AFPrintf(&UserDat,sout,MAG "[" CYN "15" MAG "]" WHT "          Use handles: " YEL "%s\n", ((plate.Flag & HANDLES_AREA) ? "Yes" : "No"));
   AFPrintf(&UserDat,sout,MAG "[" CYN "16" MAG "]" WHT "       Use signatures: " YEL "%s\n", ((plate.Flag & SIGNATURE_AREA) ? "Yes" : "No"));

   OneLine();

   if(AreaType == 0)
      AFPrintf(&UserDat,sout,MAG "[" CYN "17" MAG "]" WHT "           Translator: " YEL "%s%s\n", ((strlen(plate.processor) > 0) ? "DLGConfig:Batch/" : ""),
                                                                                              ((strlen(plate.processor) > 0) ? plate.processor : "NONE") );
/// File only -- validation, freq, and temp-download
   if(AreaType)
   {
      OneLine();
      AFPrintf(&UserDat,sout,MAG "[" CYN "18" MAG "]" WHT "     File Requestable: " YEL "%s\n", ((plate.Flag & FREQ_AREA) ? "Yes" : "No"));
      AFPrintf(&UserDat,sout,MAG "[" CYN "19" MAG "]" WHT " Copy before Download: " YEL "%s\n", ((plate.Flag & TEMP_DOWNLOAD) ? "Yes" : "No"));
      AFPrintf(&UserDat,sout,MAG "[" CYN "20" MAG "]" WHT "     Validate Uploads: " YEL "%s\n", ((plate.Flag & VALIDATION_AREA) ? "Yes" : "No"));
   }
//-

   if((AreaType == 0) || (plate.Flag & VALIDATION_AREA))
      if(plate.Capacity)
         AFPrintf(&UserDat,sout,MAG "[" CYN "21" MAG "]" WHT "%21.21s: " YEL "%ld\n", (AreaType ? "Validation Area" : "Message Capacity"),plate.Capacity);
      else
         AFPrintf(&UserDat,sout,MAG "[" CYN "21" MAG "]" WHT "%21.21s: " YEL "NONE\n", "Validation Area");

   if(AreaType == 0)
   {
      AFPrintf(&UserDat,sout,MAG "[" CYN "22" MAG "]" WHT "     Renumber Trigger: " YEL "%ld\n", plate.UpperLimit);

      Get_Charset_Name(plate.savecharset,charset);
      AFPrintf(&UserDat,sout,MAG "[" CYN "23" MAG "]" WHT "        Character Set: " MAG "(" CYN "%ld" MAG ") " YEL "%s\n", plate.savecharset,charset);
   }

   AFPrintf(&UserDat,sout,WHT "\n");
   Draw_Line(UserDat.Screen_Width);
   OneLine();
}
//-
/// Get_Charset_Name
void Get_Charset_Name(char Set, char *Name)
{
   struct CharSet cs;

   if(AreaType) return;

   if(Set == 0)
   {
      strcpy(Name,"Default");
      return;
   }

   cs.number = Set;

   if(0 == GetStruct("DLGConfig:Charsets/Charsets.BBS",(char *)&cs,sizeof(struct CharSet),1))
      strcpy(Name,cs.name);
   else
      strcpy(Name,cs.name);

   return;
}
//-

/// Change_Auto_Access
void Change_Auto_Access(struct Msg_Area_Template *plate)
{
   BOOL  b;

   b = plate->Flag & AUTO_ACCESS_AREA;

   if(b)
      plate->Flag = plate->Flag & ~AUTO_ACCESS_AREA;
   else
      plate->Flag = plate->Flag | AUTO_ACCESS_AREA;

   if(!b)
   {
      TwoLines();
      Set_Auto_Access(plate);
   }
   else
   {
      plate->llevel = 1;
      plate->ulevel = 1;
   }
}
//-
/// Change_Echo_Area_Flag
BOOL Change_Echo_Area_Flag(struct Msg_Area_Template *plate)
{
   BOOL  e;
   BOOL  n;
   BOOL  u;
   BOOL  b;

   if (AreaType) return( FALSE );

   e = plate->Flag & ECHO_AREA;
   n = plate->Flag & NETMAIL_AREA;
   u = plate->Flag & NEWSGROUP_AREA;

///   Trap netmail area
   if(n)
   {
      AFPrintf(&UserDat,sout, YEL "\nThis area is already set up as a netmail area!\n\n");
      b = finput(0,"Do you really wish to change this to an echo area? %a7->");

      if(b == 0) return( FALSE );
   }
//-
///   Trap newsgroup
   if(u)
   {
      AFPrintf(&UserDat,sout, YEL "\nThis area is already set up as a newsgroup!\n\n");
      b = finput(0,"Do you really wish to change this to an echo area? %a7->");

      if(b == 0) return( FALSE );
   }
//-

   if(e)
      plate->Flag = plate->Flag & ~ECHO_AREA;
   else
      plate->Flag = plate->Flag | ECHO_AREA;

   strcpy(plate->origin,"");

   plate->Flag = plate->Flag & ~NETMAIL_AREA;
   plate->Flag = plate->Flag & ~NEWSGROUP_AREA;

   OneLine();
   Change_Origin(plate);

   return( TRUE );
}
//-
/// Change_SeenBy_Flag
void Change_SeenBy_Flag(struct Msg_Area_Template *plate)
{
   if(AreaType) return;

   if(plate->Flag & HIDE_SEENBY)
      plate->Flag = plate->Flag & ~HIDE_SEENBY;
   else
      plate->Flag = plate->Flag | HIDE_SEENBY;

   return;
}
//-
/// Change_Origin
BOOL Change_Origin(struct Msg_Area_Template *plate)
{
   BOOL  e;
   BOOL  u;
   BOOL  b;

   char  s[74];

   long  l;

   if(AreaType) return( FALSE );

   e = plate->Flag & ECHO_AREA;
   u = plate->Flag & NEWSGROUP_AREA;

   if(e && !u)
   {
      long d;

      d = strlen(plate->origin);

      if(d)
         strcpy(s,plate->origin);
      else
         strcpy(s,"");

      l = DLGInput(NULL,plate->origin,plate->origin,74,74,0,"Custom Origin line (return for default) %a7-> ");
      OneLine();

      if(l == 0)
      {
         strcpy(plate->origin,"");

         if(d == 0)
            b = FALSE;
         else
            b = TRUE;
      }
      else
      {
         if(!Stricmp(s,plate->origin))
            b = FALSE;
         else
            b = TRUE;
      }

      return( b );
   }

   strcpy(plate->origin,"");

   return( FALSE );
}
//-
/// Change_Netmail_Area_Flag
BOOL Change_Netmail_Area_Flag(struct Msg_Area_Template *plate)
{
   BOOL  e;
   BOOL  n;
   BOOL  u;
   BOOL  b;

   if(AreaType) return( FALSE );

   e = plate->Flag & ECHO_AREA;
   n = plate->Flag & NETMAIL_AREA;
   u = plate->Flag & NEWSGROUP_AREA;

///   Trap echo area
   if(e)
   {
      AFPrintf(&UserDat,sout, YEL "\nThis area is already set up as am echo area!\n\n");
      b = finput(0, "Do you really wish to change this to a netmail area? ->");

      if(b == 0) return( FALSE );
   }
//-
///   Trap newsgroup
   if(u)
   {
      AFPrintf(&UserDat,sout, YEL "\nThis area is already set up as a newsgroup!\n\n");
      b = finput(0,"Do you really wish to change this to a netmail area? $a7->");

      if(b == 0) return( FALSE );
   }
//-

   if(n)
      plate->Flag = plate->Flag & ~NETMAIL_AREA;
   else
      plate->Flag = plate->Flag | NETMAIL_AREA;

   strcpy(plate->origin,"");

   plate->Flag = plate->Flag & ~ECHO_AREA;
   plate->Flag = plate->Flag & ~NEWSGROUP_AREA;

   return( TRUE );
}
//-
/// Change_Newsgroup_Flag
BOOL Change_Newsgroup_Flag(struct Msg_Area_Template *plate)
{
   BOOL  e;
   BOOL  n;
   BOOL  u;
   BOOL  b;

   if(AreaType) return( FALSE );

   e = plate->Flag & ECHO_AREA;
   n = plate->Flag & NETMAIL_AREA;
   u = plate->Flag & NEWSGROUP_AREA;

///   Trap echo area
   if(e)
   {
      AFPrintf(&UserDat,sout, YEL "\nThis area is already set up as am echo area!\n\n");
      b = finput(0,"Do you really wish to change this to a newsgroup? %a7->");

      if(b == 0) return( FALSE );
   }
//-
///   Trap netmail area
   if(n)
   {
      AFPrintf(&UserDat,sout, YEL "\nThis area is already set up as a netmail area!\n\n");
      b = finput(0, "Do you really wish to change this to a newsgroup? %a7->");

      if(b == 0) return( FALSE );
   }
//-

   if(u)
      plate->Flag = plate->Flag & ~NEWSGROUP_AREA;
   else
      plate->Flag = plate->Flag | NEWSGROUP_AREA;

   strcpy(plate->origin,"");

   plate->Flag = plate->Flag & ~ECHO_AREA;
   plate->Flag = plate->Flag & ~NETMAIL_AREA;

   OneLine();
   Change_Origin(plate);

   return( TRUE );
}
//-
/// Change_Alias_Flag
void Change_Alias_Flag(struct Msg_Area_Template *plate)
{
   if(plate->Flag & HANDLES_AREA)
      plate->Flag = plate->Flag & ~HANDLES_AREA;
   else
      plate->Flag = plate->Flag | HANDLES_AREA;

   return;
}
//-
/// Change_Signature_Flag
void Change_Signature_Flag(struct Msg_Area_Template *plate)
{
   if(plate->Flag & SIGNATURE_AREA)
      plate->Flag = plate->Flag & ~SIGNATURE_AREA;
   else
      plate->Flag = plate->Flag | SIGNATURE_AREA;

   return;
}
//-
/// Change_Translator
BOOL Change_Translator(struct Msg_Area_Template *plate)
{
   char  s[12];

   long  l;
   long  d;

   if(AreaType) return( FALSE );

   d = strlen(plate->processor);

   if(d)
      strcpy(s,plate->processor);
   else
      strcpy(s,"");

   l = DLGInput(NULL,plate->processor,plate->processor,12,12,0, "Message translator: DLGConfig:Batch/");
   OneLine();

   if(l == 0)
   {
      strcpy(plate->processor,"");

      if(d == 0)
         return( FALSE );
      else
         return( TRUE );
   }
   else
   {
      if(!Stricmp(plate->processor,s))
         return( FALSE );
      else
         return( TRUE );
   }

   strcpy(plate->processor,"");
   return( FALSE );
}
//-
/// Change_Capacity
BOOL Change_Capacity(struct Msg_Area_Template *plate)
{
   BOOL  b = FALSE;
   BOOL  o = FALSE;

   SHORT d;
   SHORT s  =  plate->Capacity;

   if(AreaType == 0)
   {
      if(plate->Capacity > 10)
         d = plate->Capacity;
      else
         d = 100;

   }
   else
   {
      d = plate->Capacity;

      if((d >= 1) && (d <= 9999))
         d = plate->Capacity;
      else
         d = 0;

   }


   if(AreaType == 0)
   {
      plate->Capacity = iinput(10, 9000 ,d, "How many messages do you wish to store in this area? %a7-> ");
   }
   else
   {
      while(!o)
      {
         plate->Capacity   = iinput(0,9999,0, "Which file area will hold unvalidated files for this area? %a7-> ");
         OneLine();

         if(plate->Capacity != 0)
            o = IsAreaValid(plate->Capacity);
         else
            o = TRUE;
      }
   }

   OneLine();

   if(plate->Capacity == s)
      b = FALSE;
   else
      b = TRUE;

   if(AreaType == 0)
   {
      if(plate->Capacity > plate->UpperLimit)
      {
         plate->UpperLimit = plate->Capacity * 2;

         if(plate->UpperLimit > 9000) plate->UpperLimit = 9999;
         b = TRUE;
      }
   }

   return(b);
}
//-
/// Change_Renumber
BOOL Change_Renumber(struct Msg_Area_Template *plate)
{
   SHORT d;
   SHORT s  =  plate->UpperLimit;

   if(AreaType) return( FALSE );

   if(plate->UpperLimit > plate->Capacity)
      d = plate->UpperLimit;
   else
      d = plate->Capacity + 1;

   plate->UpperLimit   = iinput( (plate->Capacity + 1),9999,d, "How many messages do you wish to trigger a re-numbering? %a7-> ");
   OneLine();

   if(plate->UpperLimit == s)
      return( FALSE );
   else
      return( TRUE );
}
//-
/// Change_Charset
BOOL Change_Charset(struct Msg_Area_Template *plate)
{
   SHORT s  =  plate->savecharset;

   if(AreaType) return ( FALSE );

   ListSets(255);
   plate->savecharset = iinput(1,255,s , "Character set to store messages in (RETURN for default) %a7-> ");
   OneLine();

   if(plate->savecharset == s)
      return( FALSE );
   else
      return( TRUE );
}
//-
/// Change_Freq_Area_Flag
void Change_Freq_Area_Flag(struct Msg_Area_Template *plate)
{
   if(AreaType == 0) return;

   if(plate->Flag & FREQ_AREA)
      plate->Flag = plate->Flag & ~FREQ_AREA;
   else
      plate->Flag = plate->Flag | FREQ_AREA;

   return;
}
//-
/// Change_Temp_Download_Flag
void Change_Temp_Download_Flag(struct Msg_Area_Template *plate)
{
   if(AreaType == 0) return;

   if(plate->Flag & TEMP_DOWNLOAD)
      plate->Flag = plate->Flag & ~TEMP_DOWNLOAD;
   else
      plate->Flag = plate->Flag | TEMP_DOWNLOAD;

   return;
}
//-
/// Change_Validation_Flag
void Change_Validation_Flag(struct Msg_Area_Template *plate)
{
   BOOL  b;

   if(AreaType == 0) return;

   b = (plate->Flag & VALIDATION_AREA);

   if(b)
      plate->Flag = plate->Flag & ~VALIDATION_AREA;
   else
      plate->Flag = plate->Flag | VALIDATION_AREA;

   plate->Capacity = 0;

   if(!b) Change_Capacity(plate);

   return;
}
//-

