#include <stdlib.h>
#include <string.h>

#include "DLGRexxBase.h"

#include <dlg/resman.h>

#include <rexx/errors.h> // Leave this in for error reporting

#include <pragmas/dlg.h>

#include <proto/dlg.h>

#include "Protos.h"

extern   char *TextRC;

/****************************************************************************/

/// ActivatePort
LONG  Cmd_ActivatePort(STRPTR *Args, LONG *Error, LONG *NumArgs, struct DLGRexxBase *DLGRexxBase)
{
   if(*NumArgs == 2)
      return(ActivatePort(Args[0],Args[1]));
   else
      return(ActivatePort(Args[0],""));
}
//-
/// Deactivateport
LONG  Cmd_DeactivatePort(STRPTR *Args, LONG *Error, LONG *NumArgs, struct DLGRexxBase *DLGRexxBase)
{
   LONG  rc;

   if(*NumArgs == 2)
      rc = ImmedLockPort(Args[0],Args[1],"Shutting down port", 0, NULL);
   else
      rc = ImmedLockPort(Args[0],"DEACTIVATE","Shutting down port", 0, NULL);

   if(rc != RMNOERR) return(rc);

   return(DeActivatePort(Args[0],"DEACTIVATE"));
}
//-
/// FreePort
LONG  Cmd_FreePort(STRPTR *Args, LONG *Error, LONG *NumArgs, struct DLGRexxBase *DLGRexxBase)
{
   if(*NumArgs == 2)
      return(FreePort(Args[0],Args[1]));
   else
      return(FreePort(Args[0],"DIALOG"));
}
//-
/// ImmedLockPort
LONG  Cmd_ImmedLockPort(STRPTR *Args, LONG *Error, LONG *NumArgs, struct DLGRexxBase *DLGRexxBase)
{
   LONG pri = 0;

   if(*NumArgs >= 4)
   {
      pri = StringToNumber(Args[3],DLGRexxBase);

      if( (pri < -127) || (pri > 128))
      {
         (*Error) = ERR10_018;
         return(0);
      }

   }

   return(ImmedLockPort(   Args[0],
                           (*NumArgs > 1) ? (char *)Args[1] : "DIALOG",
                           (*NumArgs > 2) ? (char *)Args[2] : "No Reason Given",
                           (char) pri,
                           (*NumArgs > 4) ? (char *)Args[4] : ""
                        ));
}
//-
/// LockPort
LONG  Cmd_LockPort(STRPTR *Args, LONG *Error, LONG *NumArgs, struct DLGRexxBase *DLGRexxBase)
{
   LONG pri = 0;

   if(*NumArgs >= 4)
   {
      pri = StringToNumber(Args[3],DLGRexxBase);

      if( (pri < -127) || (pri > 128))
      {
         (*Error) = ERR10_018;
         return(0);
      }

   }

   return(LockPort(  Args[0],
                     (*NumArgs > 1) ? (char *)Args[1] : "DIALOG",
                     (*NumArgs > 2) ? (char *)Args[2] : "No Reason Given",
                     (char) pri,
                     (*NumArgs > 4) ? (char *)Args[4] : ""
                  ));
}
//-
/// TransferPortLock
LONG  Cmd_TransferPortLock(STRPTR *Args, LONG *Error, LONG *NumArgs, struct DLGRexxBase *DLGRexxBase)
{
   LONG pri = 0;

   if(*NumArgs >= 5)
   {
      pri = StringToNumber(Args[4],DLGRexxBase);

      if( (pri < -127) || (pri > 128))
      {
         (*Error) = ERR10_018;
         return(0);
      }

   }

   return(TransferPortLock(   Args[0],
                             (*NumArgs > 1) ? (char *)Args[1] : "DIALOG",
                             (*NumArgs > 2) ? (char *)Args[2] : "DIALOG",
                             (*NumArgs > 3) ? (char *)Args[3] : "No Reason Given",
                             (char) pri,
                             (*NumArgs > 5) ? (char *)Args[5] : ""
                          ));
}
//-
/// GetPortInfo
LONG  Cmd_GetPortInfo(STRPTR *Args, LONG *Error, LONG *NumArgs, struct DLGRexxBase *DLGRexxBase)
{
   char              t[20];
   LONG              myRC  =  RMNOERR;
   struct   PortInfo pi;

   if(TextRC)  { free(TextRC); TextRC = NULL; }

   pi.port = strdup((char *)Args[0]);

   myRC = GetPortInfo(&pi);

   if(myRC == RMNOERR)
   {
      LONG MaxLen = 0;

      MaxLen = strlen(pi.passwd) + strlen(pi.reason) + 4 + strlen(pi.breakcommand);
      MaxLen = MaxLen * 3;

      TextRC = calloc(1,MaxLen);

      sprintf(TextRC,"PASS \"%s\" REASON \"%s\" PRI %ld BREAKCMD \"%s\"",  pi.passwd,     pi.reason,
                                                                           pi.priority,   pi.breakcommand);
      FreePortInfo(&pi);
   }  // myRC == RMNOERR
   else
   {
      NumberToString(myRC,t,DLGRexxBase);
      TextRC = strdup(t);
   }

   return(0);
}
//-
/// ListPorts
LONG  Cmd_ListPorts(STRPTR *Args, LONG *Error, LONG *NumArgs, struct DLGRexxBase *DLGRexxBase)
{
   char              ports[256];
   char              t[20];
   LONG              myRC  =  RMNOERR;

   if(TextRC)  { free(TextRC); TextRC = NULL; }


   myRC = ListPorts( ports, (*NumArgs > 0) ? (char *)Args[0] : "");

   if(myRC == RMNOERR)
   {
      if(strlen(ports) == 0)
      {
         myRC = -3;
      }  // strlen(ports)
      else
      {
         TextRC = strdup(ports);
      }

   }  // myRC == RMNOERR

   if(myRC != RMNOERR)
   {
      NumberToString(myRC,t,DLGRexxBase);
      TextRC = strdup(t);
   }

   return(0);
}
//-

