#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <exec/types.h>
#include <exec/lists.h>
#include <ctype.h>

#include <dlg/dlg.h>
#include <dlg/resman.h>

#include <link/io.h>
#include <link/lang.h>

#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/dlg.h>

#include <pragmas/dlg.h>

#include <private/Version.h>
#define  ObjRev "1"
const UBYTE version[]="\0$VER: ResourceReport " BUILDVER "." ObjRev " " COPYRIGHT " by Digerati Dreams "__AMIGADATE__;

void  main(int, char **);
void  DisplayResReport (struct List *, UBYTE, UBYTE);
void  DisplayLockReport(struct List *, UBYTE);
void _CXBRK  (void);
void  Usage  (char *);
void  CleanUp(char *);

BPTR            sout;
char          **SA;
struct Library *DLGBase = NULL;
struct List    *ResList = NULL;


void main(int argc,char **argv)

{char port  = FALSE;
 char msg   = FALSE;
 char file  = FALSE;
 char misc  = FALSE;
 char dmenu = FALSE;
 char locks = FALSE;

 sout    = Output();
 DLGBase = OpenLibrary(DLGNAME,DLGVERSION);
 if (!DLGBase)               CleanUp("Unable to open dlg.library");
 if (!(SA = getlang(NULL)))  CleanUp("Can't read language file");

 AFPrintf(NULL, sout, "\n");

 while(--argc>0)
      {char *s;

       s = *++argv;
       if (*s++=='-')
          {while(*s)
                {switch(toupper(*s))
                       {case 'P': port  = TRUE;
                                  break;

                        case 'M': msg   = TRUE;
                                  break;

                        case 'F': file  = TRUE;
                                  break;

                        case 'R': misc  = TRUE;
                                  break;

                        case 'S': dmenu = TRUE;
                                  break;

                        case 'L': locks = TRUE;
                                  break;

                         default: Usage("Bad switch");
                                  break;
                       }

                 s++;
                }
          }
      }

 if (!(port|msg|file|misc|dmenu))
     {port  = TRUE;
      msg   = TRUE;
      file  = TRUE;
      misc  = TRUE;
      dmenu = TRUE;
     }

 ResList = (struct List *)GetResReport();
 if (port)  DisplayResReport(ResList, NODE_PORT, locks);

 if (msg)
    {AFPrintf(NULL, sout, SA[2906]);
     DisplayResReport(ResList, NODE_MAREA, locks);
    }

 if (file)
    {AFPrintf(NULL, sout, SA[2907]);
     DisplayResReport(ResList, NODE_FAREA, locks);
    }

 if (misc)
    {AFPrintf(NULL, sout, SA[2908]);
     DisplayResReport(ResList, NODE_MISC, locks);
    }

 if (dmenu)
    {AFPrintf(NULL, sout, SA[2909]);
     DisplayResReport(ResList, NODE_MENU, locks);
    }

 FreeResReport(ResList);
 ResList = 0;

 AFPrintf(NULL, sout, "\n");
 CleanUp(NULL);
}


void DisplayResReport(struct List *lst, UBYTE type, UBYTE lflag)

{struct ResRepNode *rrn;
 struct Node       *nd;

 AFPrintf(NULL, sout, "\n");

 nd = lst->lh_Head;

 while(nd->ln_Succ)
      {if (nd->ln_Type!=type)
          {nd=nd->ln_Succ;
           continue;
          }

       rrn = (struct ResRepNode *)nd;

       switch(nd->ln_Type)
             {case NODE_PORT: AFPrintf(NULL, sout, SA[2910],nd->ln_Name);
                              AFPrintf(NULL, sout, SA[2911],(rrn->bgcommand)?rrn->bgcommand:SA[2912]);
                              AFPrintf(NULL, sout, SA[2913],(rrn->language)?rrn->language:SA[2912]);
                              AFPrintf(NULL, sout, SA[2914],(rrn->menu)?rrn->menu:SA[2912]);
                              break;

             case NODE_MAREA:
             case NODE_FAREA: AFPrintf(NULL, sout, SA[2915], nd->ln_Name, rrn->users);
                              break;

             case NODE_MISC:
             case NODE_MENU:  AFPrintf(NULL, sout, SA[2916],nd->ln_Name);
                              break;
            }

      if (lflag)
         {if (rrn->activelocks)   DisplayLockReport(rrn->activelocks,  0);
          if (rrn->pendinglocks)  DisplayLockReport(rrn->pendinglocks, 1);
         }

      nd=nd->ln_Succ;
     }
}


void DisplayLockReport(struct List *lst,UBYTE flag)

{struct LockRepNode *lrn;
 struct Node        *nd;

 AFPrintf(NULL, sout, SA[2917],(flag)?SA[2918]:SA[2919]);

 nd=lst->lh_Head;

 while(nd->ln_Succ)
      {lrn = (struct LockRepNode *)nd;

       if (nd->ln_Type == NODE_PORT)
           AFPrintf(NULL, sout, SA[2920],(lrn->breakcommand)?lrn->breakcommand:SA[2912]);

       AFPrintf(NULL, sout, SA[2921],nd->ln_Name);
       AFPrintf(NULL, sout, SA[2922],(lrn->reason)?lrn->reason:SA[2912]);
       AFPrintf(NULL, sout, SA[2923],nd->ln_Pri);
       AFPrintf(NULL, sout, SA[2924],(lrn->type&PENDLOCK)?SA[2925]:SA[2926],(lrn->type&WRITELOCK)?SA[2927]:SA[2928],(lrn->type&QUICKLOCK)?SA[2929]:SA[2930]);

       nd=nd->ln_Succ;
      }
}


void _CXBRK(void)

{AFPrintf(NULL, sout, SA[2931]);
 CleanUp(NULL);
}


void Usage(char *string)

{AFPrintf(NULL, sout, SA[2932],string);
 AFPrintf(NULL, sout, SA[2933]);
 AFPrintf(NULL, sout, SA[2934]);
 AFPrintf(NULL, sout, SA[2935]);
 AFPrintf(NULL, sout, SA[2936]);
 AFPrintf(NULL, sout, SA[2937]);
 AFPrintf(NULL, sout, SA[2938]);
 AFPrintf(NULL, sout, SA[2939]);

 CleanUp(NULL);
}


void CleanUp(char *s)

{if (DLGBase)  CloseLibrary(DLGBase);

 if (s)
    {Write(sout, "\n Error: ", 9);
     Write(sout,  s,    strlen(s));
     Write(sout, "\n\n",       2);
    }

 exit(s?5:0);
}
