#include <stdlib.h>
#include <string.h>
#include <exec/types.h>
#include <ctype.h>

#include <dlg/dlg.h>
#include <dlg/resman.h>

#include <link/io.h>
#include <link/lang.h>

#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/dlg.h>

#include <pragmas/dlg.h>

#include <private/Version.h>
#define  ObjRev "1"
const UBYTE version[]="\0$VER: GetPort " BUILDVER "." ObjRev " " COPYRIGHT " by Digerati Dreams "__AMIGADATE__;

void main   (int, char **);
void Usage  (char *);
void CleanUp(char *);

BPTR            sout;
char          **SA;
struct Library *DLGBase = NULL;

void main(int argc, char **argv)

{long  retval;
 char  port[4] = "";
 char *passwd  = "DIALOG";
 char *reason  = "Unspecified";
 char  pri     =  0;
 char  immed   =  0;
 char *bc      = "";

 sout    = Output();
 DLGBase = OpenLibrary(DLGNAME, DLGVERSION);
 if (!DLGBase)  CleanUp("Unable to open dlg.library");

 AFPrintf(NULL, sout, "\n");

/// parse args
 while(--argc>0)
      {char *s; 

       s = *++argv;
       if (*s++ == '-')
          {while(*s)
                {switch(toupper(*s))
                       {case 'P': if (!--argc)  break;
                                  strncpy(port, *++argv, 3);
                                  port[3] = 0;
                                  Upper(port);
                                  break;

                        case 'K': if (!--argc)  break;
                                  passwd = *++argv;
                                  break;

                        case 'R': if (!--argc)  break;
                                  reason = *++argv;
                                  break;

                        case 'L': if (!--argc)  break;
                                  pri = atoi(*++argv);
                                  break;

                        case 'B': if (!--argc)  break;
                                  bc = *++argv;
                                  break;

                        case 'I': immed = 1;
                                  break;
                       }

                 s++;
                }
          }
      }
//-

 if (!(SA = getlang(port)))  CleanUp("Can't read language file");
 if (!port[0])             Usage(SA[2804]);
 if (pri < 0  &&  !bc[0])  Usage(SA[2805]);

 if (immed)
     retval = ImmedLockPort(port,passwd,reason,pri,bc);
   else
     retval = LockPort(port,passwd,reason,pri,bc);

 if (retval == RMNOERR)
     AFPrintf(NULL, sout, SA[2806]);
   else
     if (retval == NORM)
         CleanUp(SA[2807]);
       else
         if (retval == BADPORT)
             CleanUp(SA[2808]);
           else
             if (retval == NOTLOCKED)
                 CleanUp(SA[2809]);
               else
                 CleanUp(SA[2810]);

 AFPrintf(NULL, sout, "\n");
 CleanUp(NULL);
}


void Usage(char *string)

{AFPrintf(NULL, sout, SA[2811], string);
 AFPrintf(NULL, sout, SA[2812]);
 AFPrintf(NULL, sout, SA[2813]);
 AFPrintf(NULL, sout, SA[2814]);
 AFPrintf(NULL, sout, SA[2815]);
 AFPrintf(NULL, sout, SA[2816]);
 AFPrintf(NULL, sout, SA[2817]);

 CleanUp(NULL);
}


void CleanUp(char *s)

{if (DLGBase)  CloseLibrary(DLGBase);

 if (s)
    {Write(sout, "\n Error: ", 9);
     Write(sout,  s,    strlen(s));
     Write(sout, "\n\n",       2);
    }

 exit(s?5:0);
}
