#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <dos.h>
#include <exec/types.h>
#include <libraries/dosextens.h>

#include <dlg/rxint.h>
#include <dlg/portconfig.h>

#include <dlg_private/dlg.h>

#include <proto/dlg.h>
#include <proto/dos.h>
#include <proto/exec.h>

#include <pragmas/dlg.h>

static char version[]="$VER: HangUp 2.1  1995-1997 by DLG Development "__AMIGADATE__"";

void  main(void);
void  sendstring(char *);
BOOL  NukeRexx(char *);
void _CXBRK(void);

BPTR  sout;
char  Ext[4];

struct Library *DLGBase;
char          **SA;


void main(void)
{
   char         filename[80];
   struct Port  MyPort;
   struct Modem MyModem;

   sout = Output();

   if (!(DLGBase = OpenLibrary(DLGNAME, DLGVERSION)))  exit(5);
   if (GetDevName(Ext) == -1)                          exit(5);
   if (!(SA = getlang(Ext)))                           exit(5);

   ASPrintf(NULL, filename,"DlgConfig:Port/%s.port",Ext);

   if (GetFirstStruct(filename,(char *)&MyPort,sizeof(MyPort))==-1)
   {
      AFPrintf(NULL,sout,SA[924], filename);
      _CXBRK();
   }

   ASPrintf(NULL, filename,"DlgConfig:Port/%s",MyPort.ModemFile);

   if (GetFirstStruct(filename,(char *)&MyModem,sizeof(MyModem))==-1)
   {
      AFPrintf(NULL,sout,SA[924], filename);
      _CXBRK();
   }

   ASPrintf(NULL, filename, "t:%s.user", Ext);
   DeleteFile(filename);

   NukeRexx(Ext);

   if (MyModem.HangupMethod  ||  !Strnicmp(Ext,"TL",2))  _CXBRK();

   TRecover(Ext);
   ClearLine();

   ReadChar(0);
   Chk_Abort();

   while(TRUE)
   {
      WaitForChar(Input(),2000000L);
      Chk_Abort();

      sendstring(MyModem.CommandMode);
      WaitForChar(Input(),2000000L);
      Chk_Abort();

      sendstring(MyModem.Hangup);
      sendstring("\n");
   }

   _CXBRK();
}

/// sendstring()
void sendstring(char *modem)
{
   int d=0;

   while(modem[d] != '\0')
   {

      ReadChar(0);       
      Chk_Abort();
      Write(sout, &modem[d], 1);
      WaitForChar(Input(), 200000L);
      d++;
   }
}
//-

/// NukeRexx()
//  Kills off port's Arexx interface port.
BOOL NukeRexx(char *port)
{
   struct MsgPort *rxport;
   struct MsgPort *rport;
   struct RxQuery  rxq;
   char   rxaddr[6];

   ASPrintf(NULL, rxaddr, "%sRX", port);
   Upper(rxaddr);

   Forbid();
   rxport=(struct MsgPort *)FindPort(rxaddr);
   Permit();
   if (!rxport)  return(FALSE);

   rport = CreateMsgPort();
   if (!rport)  return(FALSE);

   rxq.mess.mn_Node.ln_Type = NT_MESSAGE;
   rxq.mess.mn_ReplyPort    = rport;
   rxq.mess.mn_Length       = sizeof(struct RxQuery);

   rxq.user = NULL;
   rxq.ram  = NULL;
   rxq.rstr = NULL;

   PutMsg(rxport, (struct Message *)&rxq);

   while(!GetMsg(rport))
   WaitPort(rport);

   DeleteMsgPort(rport);
   return(TRUE);
}
//-

/// _CXBRK()
void _CXBRK(void)
{
   CloseLibrary(DLGBase);
   exit(0);
}
//-
