#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>

#include <dlg/msg.h>
#include <dlg/misc.h>
#include <dlg/user.h>

#include <link/io.h>

#include <proto/dos.h>
#include <proto/dlg.h>

#include <pragmas/dlg.h>

extern struct Library *DLGBase;

BYTE CallMsgEditor(char *repfile,char *headerfile,char *bodyfile,
  struct Msg_Area *msgarea,char msgtype,char *Ext,char translate,
  struct USER_DATA *user,struct Ram_File *ram)
{
char temptitle[255],repfilechanged=FALSE;


/* if the area is an alternate area, and this is a reply, create a translated
   reply file in the t: directory */

if(repfile && msgarea->savecharset)
  {
  int sp,dp,counter;
  struct CharSet set;
  struct Msg_Header header;
  unsigned char setname[46],*body=NULL,*msgtransarray=NULL,transchar;
  ULONG size;
    
  /* load the character set strucure to get the name */

  set.number=msgarea->savecharset;
  if(GetStruct("DLGConfig:CharSets/CharSets.bbs",(char*)&set,sizeof(set),1)!=-1)
    {ASPrintf(NULL, setname, "DLGConfig:CharSets/%s.set", set.name);
    if((msgtransarray=(char *)malloc(256)))
      {
      if(GetFirstStruct(setname,msgtransarray,256)==-1)
        {
        free(msgtransarray);
        msgtransarray=NULL;
        }  
      }
    }

  /* if we successfully loaded the msgtransarray, proceed with the conversion */

  if(msgtransarray)
    {

    /* get the filesize of the repfile and allocate memory for the body */

      if(FileSize(repfile,&size)!=-1 &&
      (body=(char *)malloc((int)size-sizeof(header)+1)))
      {

      /* open the repfile */

      if((sp=open(repfile,O_RDONLY))!=EOF)
        {

        /* change the name of the repfile to the temp name */

        ASPrintf(NULL, repfile, "T:%s.repfile", Ext);
        repfilechanged=TRUE;
        DeleteFile(repfile);

        /* open the new repfile for reading */

        if((dp=open(repfile,O_RDWR+O_CREAT))!=EOF)
          {

          /* read and write the header */

          read(sp,&header,sizeof(header));
          write(dp,&header,sizeof(header));

          /* read the body into the buffer and null terminate it */

          read(sp,body,(int)size-sizeof(header));
          *(body+(int)size-sizeof(header))='\0';

          /* loop through the buffer making the conversions */

          for(counter=0;*(body+counter)!='\0';counter++)
            {
            transchar=msgtransarray[*(body+counter)];
            *(body+counter)=transchar;
            }

          /* write the buffer and close the files */

          write(dp,body,(int)size-sizeof(header));
          close(dp);
          }
        close(sp);
        }
      if(body) free(body);
      }
    free(msgtransarray);
    }
  }


  
if(CallEditor(repfile,headerfile,bodyfile,msgtype,user,ram,Ext))
  {
  if(repfilechanged)
    DeleteFile(repfile);
  return(-1);
  }

if(strlen(msgarea->processor) && translate)
  {ASPrintf(NULL, temptitle, "Execute DLGCONFIG:Batch/%s %s", msgarea->processor, Ext);
   Execute(temptitle,0L,0L);
  }

if(repfilechanged)
  DeleteFile(repfile);
return(0);
}
