#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <fcntl.h>
#include <exec/types.h>
#include <dialog/user.h>

#include <proto/dos.h>
#include <proto/dlg.h>

extern struct Library  *DLGBase;
extern char           **SA;
extern struct USER_DATA StUser;

struct Integer {
   USHORT value;
}
;

BOOL AddGlobalArea(SHORT upper,SHORT lower,SHORT number,char mode,char del,char *port)

{
   char  *users = NULL;
   char   userfile[53];
   char   globalfile[60];
   char   globalfile2[60];
   ULONG  size;
   long   index;
   BPTR   sout;
   struct USER_DATA User;


   /* load the users into memory */
   if (FileSize("DLGConfig:Misc/Users.bbs",&size) == -1)   return(FALSE);
   if (!(users = malloc(size)))                            return(FALSE);
   if (GetFirstStruct("DLGConfig:Misc/Users.bbs", (char *)users, size)==-1)
   {
      free(users);
      return(FALSE);
   }

   sout = Output();

   /* main loop */
   AFPrintf(&StUser, sout, SA[3384]);

   for(index = 0; index < size; index+=36L)
   {
      /* load user data file */
      AFPrintf(&StUser, sout, SA[3385], users+index);

      /* If we are adding an area or we are changing levels load the user data */
      if (del==0 || del==2)
      {
         ASPrintf(NULL,userfile,"USER:%s/User.data",users+index);
         UnderScore(userfile);
         if (GetFirstStruct(userfile,(char *)&User,sizeof(User))==-1)
         {
            AFPrintf(&StUser, sout, SA[3386]);
            continue;
         }
      }

      /* If we are adding a new area, or we are changing levels, AND
        the user has no access to the area, print no access and continue */
      if ((del==0 || del==2) && (User.User_Level<lower || User.User_Level>upper))
      {
         AFPrintf(&StUser, sout, SA[3387]);
         continue;
      }

      /* Calculate the name of the global file to write to */
      if (mode)
      {
         ASPrintf(NULL,globalfile,"USER:%s/GlobalAreas.file",users+index);
         globalfile2[0]='\0';
      }
      else
      {
         ASPrintf(NULL,globalfile, "USER:%s/GlobalAreas.msg",     users+index);
         ASPrintf(NULL,globalfile2,"USER:%s/GlobalAreas.archive", users+index);
      }

      UnderScore(globalfile2);
      UnderScore(globalfile);

      /* If it is a level change, check for the existance of the area
        in the users newscan area and loop if it already exists */
      if (del==2)
      {
         if (ExistsGlobalArea(globalfile,(USHORT)number))
         {
            AFPrintf(&StUser, sout, SA[3388]);
            continue;
         }
      }

      /* if we are adding a new area, or making a level change add the area
        and report */
      if (del==0 || del==2)
      {
         if (!ExistsGlobalArea(globalfile,(USHORT)number))
         {
            if (AddArea(globalfile,(USHORT)number))
            {
               char informstr[80];

               ASPrintf(NULL, informstr, "%s area [%d] added to your newscan list",mode?"File":"Message",number);
               Inform(users+index,informstr,port,0);
               AFPrintf(&StUser, sout, SA[3389]);
            }
            else
            AFPrintf(&StUser, sout, SA[3390]);
         }
         else
         {
            AFPrintf(&StUser, sout, SA[3388]);
            continue;
         }
      }

      /* if we are deleting an area, delete the area from the global file
        regardless */
      else
      {
         if (globalfile2[0]!='\0')  DelArea(globalfile2,(USHORT)number);

         if (DelArea(globalfile,(USHORT)number))
            AFPrintf(&StUser, sout, SA[3391]);
         else
            AFPrintf(&StUser, sout, SA[3392]);
      }
   }

   free(users);
   AFPrintf(NULL, sout, "\n");
   return(TRUE);
}
