#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <exec/types.h>

#include <dlg/file.h>
#include <dlg/msg.h>
#include <dlg/user.h>
#include <dlg/log.h>

#include <Link/file.h>
#include <Link/io.h>

#include <proto/dos.h>
#include <proto/dlg.h>

#include <pragmas/dlg.h>


extern struct Library  *DLGBase;
extern char           **SA;
extern struct USER_DATA UserDat;

BOOL DescribeFiles(char *name, struct USER_DATA *user, struct Msg_Area *curarea,
                   struct Ram_File *ram, char *ext, char *stack, char *pswd,
                   LONG dirlimit, struct Msg_Log *log)

{BPTR  sout;
 ULONG size;

 char *bodybuf;
 char *tempfilename;

 char  sourcepath [90];
 char  filename   [37];
 char  fullname   [128];
 char  displayname[37];

 int   retval,leftflag=0;
 char  toname   [37];
 char  status   [36];
 char  comment  [150];
 char  rheader  [13];
 char  rbody    [11];
 char  signature[60];

 long area;

 struct File_Header   header;
 struct Msg_Area      areainfo;
 struct SearchCookie *sc = NULL;

 sout = Output();

 /* Determine tempupload path */
 ASPrintf(NULL, sourcepath, "FILE:Tempuploads/%s", name);
 UnderScore(sourcepath);

 if (!Exists(sourcepath))  return(FALSE);
 CD(sourcepath);


 /* Find the file and load the file comment */
 AFPrintf(NULL, sout, "%c", 7);

 sc = SearchStart(sourcepath, "*");
 while(tempfilename = SearchNext(sc))
      {strcpy(filename,tempfilename);
       ASPrintf(NULL, fullname, "%s/%s", sourcepath, filename);
       GetComment(fullname, comment);

       if (sscanf(comment,"Area: %d User: %35s Status: %8s",&area,toname,status)!=3)
          {DeleteFile(fullname);
           continue;
          }

       /* If a partial upload, leave it alone and go on to the next file */
       if (!Stricmp(status,"Partial"))  continue;

       /* If anything else other than Complete, delete the file and move on to next */
       if (Stricmp(status,"Complete"))
          {DeleteFile(fullname);
           continue;
          }

       /* Build the header of the file with information from the file */
       strcpy(header.From,name);
       Capitalize(header.From);
       strcpy(header.Filename,filename);
       Upper(header.Filename);
       MDate(header.Date);
       header.Times_Downloaded = 0;
       FileSize(fullname,&size);
       if (dirlimit && dirlimit<size && user->User_Level<255)
          {strcpy(displayname,toname);
           DeScore(displayname);
           AFPrintf(&UserDat,sout,SA[3595],displayname,header.Filename);
           DeleteFile(fullname);
           continue;
          }

       header.Size      = size;
       header.Attribute =  0;

       ASPrintf(NULL, rheader, "T:%s.header", ext);
       ASPrintf(NULL, rbody,   "T:%s.body",   ext);

       DeleteFile(rheader);
       DeleteFile(rbody);
       AddStruct(rheader,(char *)&header,sizeof(header),1);

       if (Exists("DLGConfig:batch/Upload1.batch"))
          {char exestr[255];

           UnderScore(name);
           ASPrintf(NULL,exestr,"Execute DLGConfig:batch/Upload1.batch %s %s/%s",name,sourcepath,filename);
           DeScore(name);
           Execute(exestr,0,0);
          }

       while(TRUE)
            {
             AFPrintf(&UserDat, sout, SA[3596], filename);
             Pause();
             Chk_Abort();

             if (CallEditor(NULL,rheader,rbody,FILE_DESC,user,ram,ext)==-1)
                {char str[2];
                 AFPrintf(&UserDat,sout,SA[3597]);
                 DLGInput("",NULL,str,NULL,1,255,1);
                 AFPrintf(NULL, sout, "\n\n");

                 switch(str[0])
                       {case 'D':  DeleteFile(rheader);
                                   DeleteFile(filename);
                                   break;

                        case 'A':  CD("File:");
                                   if (sc)  SearchEnd(sc);
                                   return(FALSE);
                                   break;

                         default:  continue;
                       }
                }

             break;
            }

       if (!Exists(rheader))  continue;
  
       /* Load information for the area the file is destined for */
       if (curarea->Number!=area && area!=PVTAREA)
           ReadArea(area,&areainfo,1);
       if (curarea->Number==area)
           movmem(curarea,&areainfo,sizeof(areainfo));

       /* Add signature to the body of the file description */
       if (curarea->Flag&SIGNATURE_AREA)
          {ASPrintf(NULL, signature, "USER:%s/Signature.file", name);
           UnderScore(signature);
           Cat(rbody,signature,"\015\001SIGNATURE\015");
          }

       FileSize(rbody,&size);
       if (!(bodybuf=(char *)malloc((int)size+1)))
          {
           AFPrintf(&UserDat,sout,SA[3598]);
           continue;
          }

       /* Load body into an array */
       GetFirstStruct(rbody,(char *)bodybuf,size);
       bodybuf[(int)size]='\0';
       GetFirstStruct(rheader,(char *)&header,sizeof(header));    
       Upper(header.Filename);

       /* Load validation area information if it exists */
       if (!(log->Priv_Flag&Sysop_Access) && area!=PVTAREA && areainfo.Flag&VALIDATION_AREA)
          {if (ReadArea(areainfo.Capacity,&areainfo,1))
              {
               AFPrintf(&UserDat,sout,SA[3599]);
               header.Attribute        |= UNVALIDATED;
               header.Times_Downloaded  = area;
              }
            else
               ReadArea(area,&areainfo,1);
          }

       if (Exists("DLGConfig:batch/Upload2.batch"))
          {char exestr[255];

           UnderScore(name);
           ASPrintf(NULL,exestr,"Execute DLGConfig:batch/Upload2.batch %s %s/%s",name,sourcepath,header.Filename);
           DeScore(name);
           Execute(exestr,0L,0L);
          }

       ScreenPath(header.Filename);

       while((retval=RawUpload(sourcepath,filename,&header,bodybuf,(area==PVTAREA)?toname:NULL,&areainfo,pswd,1))==-1)
            {
             AFPrintf(&UserDat,sout,SA[3600],header.Filename);
             DLGInput(SA[3601],NULL,header.Filename,NULL,35,255,1);
             AFPrintf(NULL, sout, "\n\n");
             ScreenPath(header.Filename);
            }

       DeleteFile(rbody);
       DeleteFile(rheader);

       if (retval==-2)
          {
           AFPrintf(&UserDat,sout,SA[3602]);
           continue;
          }

       if (retval==-3)
          {
           AFPrintf(&UserDat,sout,SA[3603],toname);
           continue;
          }

       AFPrintf(&UserDat,sout,SA[3604]);

       if (area!=PVTAREA)
          {user->Bytes_Uploaded += header.Size;
           user->Files_Uploaded++;
          }
        else
         {
          ASPrintf(&UserDat,fullname,SA[3605],header.Filename,ram->Name);
          DeScore(toname);
          Inform(toname,fullname,ext,0);
          UnderScore(toname);
         }

       WriteLog(UPLOADED_FILE,name,ext,header.Filename);
       free(bodybuf);
      }

 if (sc)   SearchEnd(sc);

 sc = NULL;
 sc = SearchStart(sourcepath,"*");

 while(tempfilename = SearchNext(sc))
      {strcpy(filename,tempfilename);
       ASPrintf(NULL,fullname,"%s/%s",sourcepath,filename);
       GetComment(fullname,comment);

       AFPrintf(NULL, sout, "%s\n", comment);
       if (sscanf(comment,"Area: %d User: %35s Status: %8s",&area,toname,status)!=3)
          {DeleteFile(fullname);
           continue;
          }

       if (!Stricmp(status,"Partial"))
          {char inp[2];

           FileSize(fullname,&size);
           AFPrintf(&UserDat,sout,SA[3606],filename);
           AFPrintf(&UserDat,sout,SA[3607],size);
           DLGInput(SA[3608],NULL,inp,NULL,1,1,1);
           AFPrintf(NULL, sout, "\n\n");

           switch(inp[0])
                 {case 'D':  if (!DeleteFile(fullname))
                                  AFPrintf(&UserDat,sout,SA[3609],fullname);
                             AFPrintf(&UserDat,sout,SA[3610]);
                             break;

                   default:  leftflag++;  
                             break;
                 }

           continue;
          }
      }

 if (sc)  SearchEnd(sc);

 CD("File:");

 if (leftflag)
    {
     AFPrintf(&UserDat,sout,SA[3611]);
     AFPrintf(&UserDat,sout,SA[3612]);
    }
  else
    {sc = SearchStart(sourcepath,"*");
     if (!SearchNext(sc))
        {SearchEnd(sc);
         DeleteFile(sourcepath);
        }
      else
        SearchEnd(sc);
    }

 return(FALSE);
}
