#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <devices/tpt.h>

#include <dlg/dlg.h>

#include <link/io.h>
#include <link/lang.h>

#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/dlg.h>

#include <pragmas/dlg.h>

#include <private/Version.h>
#define  ObjRev "1"
const UBYTE version[]="\0$VER: TFlags " BUILDVER "." ObjRev " " COPYRIGHT " by Digerati Dreams "__AMIGADATE__;

void SendCtl(long,long);
void Usage(char *);
void CleanUp(char *);

UBYTE           devname[4]   = "";
long            enableflags  = 0;
long            disableflags = 0;

BPTR            sout;
char          **SA;
struct Library *DLGBase = NULL;


void main(int argc,char **argv)

{UBYTE *s;

 sout    = Output();
 DLGBase = OpenLibrary(DLGNAME,DLGVERSION);
 if (!DLGBase)               CleanUp("Unable to open dlg.library");
 if (!(SA = getlang(NULL)))  CleanUp("Can't read language file");

 AFPrintf(NULL, sout, "\n");

 while(--argc>0)
      {s = *++argv;

       if (*s++ == '-')
          {while(*s)
                {switch(*s++)
                       {case 'P':
                        case 'p':  if (!--argc)  break;
                                   strncpy(devname,*++argv,3);
                                   devname[3] = 0;
                              Upper(devname);
                                   break;

                        case 'A':  enableflags  |= T_ANSIPOS;
                                   break;

                        case 'a':  disableflags |= T_ANSIPOS;
                                   break;

                        case 'B':  enableflags  |= T_BREAK;
                                   break;

                        case 'b':  disableflags |= T_BREAK;
                                   break;

                        case 'C':  enableflags  |= T_CRLF;
                                   break;

                        case 'c':  disableflags |= T_CRLF;
                                   break;

                        case 'D':  enableflags  |= T_CTLD;
                                   break;

                        case 'd':  disableflags |= T_CTLD;
                                   break;

                        case 'E':  enableflags  |= T_ECHO;
                                   break;

                        case 'e':  disableflags |= T_ECHO;
                                   break;

                        case 'F':  enableflags  |= T_LINEFREEZE;
                                   break;

                        case 'f':  disableflags |= T_LINEFREEZE;
                                   break;

                        case 'K':  enableflags  |= T_KILL_ENABLE;
                                   break;

                        case 'k':  disableflags |= T_KILL_ENABLE;
                                   break;

                        case 'W':  enableflags  |= T_DO_PEND;
                                   break;

                        case 'w':  disableflags |= T_DO_PEND;
                                   break;

                        case 'X':  enableflags  |= T_PASS_THRU;
                                   break;

                        case 'x':  disableflags |= T_PASS_THRU;
                                   break;

                        case 'S':  enableflags  |= T_PAUSE;
                                   break;

                        case 's':  disableflags |= T_PAUSE;
                                   break;

                        case 'R':  enableflags  |= T_RAW;
                                   break;

                        case 'r':  disableflags |= T_RAW;
                                   break;

                        case 'T':  enableflags  |= T_DO_TIMEOUT;
                                   break;

                        case 't':  disableflags |= T_DO_TIMEOUT;
                                   break;

                        case 'V':  enableflags  |= T_VERB_PAUSE;
                                   break;

                        case 'v':  disableflags |= T_VERB_PAUSE;
                                   break;
                       }
                }
          }
      }
 if (!devname[0])  Usage(SA[3095]);

 if (enableflags)   SendCtl(TADDSTAT, enableflags);
 if (disableflags)  SendCtl(TDELSTAT, disableflags);

 AFPrintf(NULL, sout, "\n");
 CleanUp(NULL);
}


void SendCtl(long mod, long aux_stat)

{long retval;

 if (mod == TADDSTAT)
    {AFPrintf(NULL, sout, SA[3096]);
     retval = TSetFlags(aux_stat, devname);
    }
   else
    {AFPrintf(NULL, sout, SA[3097]);
     retval = TUnSetFlags(aux_stat, devname);
    }

 if (retval==ACTIVERR)
     AFPrintf(NULL, sout, SA[3098]);
   else
     if (retval==GENERALERR)
         AFPrintf(NULL, sout, SA[3099]);
       else
         if ((mod==TADDSTAT) && (retval & aux_stat))
              AFPrintf(NULL, sout, SA[3100]);
            else
              if ((mod==TDELSTAT)  &&  (retval & ~aux_stat))
                   AFPrintf(NULL, sout, SA[3101]);
}


void Usage(char *string)

{AFPrintf(NULL, sout, SA[3102], string);
 AFPrintf(NULL, sout, SA[3103]);
 AFPrintf(NULL, sout, SA[3104]);
 AFPrintf(NULL, sout, SA[3105]);

 AFPrintf(NULL, sout, SA[3118]);
 AFPrintf(NULL, sout, SA[3106]);
 AFPrintf(NULL, sout, SA[3107]);
 AFPrintf(NULL, sout, SA[3108]);
 AFPrintf(NULL, sout, SA[3109]);
 AFPrintf(NULL, sout, SA[3110]);
 AFPrintf(NULL, sout, SA[3111]);
 AFPrintf(NULL, sout, SA[3112]);
 AFPrintf(NULL, sout, SA[3113]);
 AFPrintf(NULL, sout, SA[3114]);
 AFPrintf(NULL, sout, SA[3115]);
 AFPrintf(NULL, sout, SA[3116]);
 AFPrintf(NULL, sout, SA[3117]);

 CleanUp(NULL);
}


void CleanUp(char *s)

{if (DLGBase)  CloseLibrary(DLGBase);

 if (s)
    {Write(sout, "\n Error: ", 9);
     Write(sout,  s,    strlen(s));
     Write(sout, "\n\n",       2);
    }

 exit(s?5:0);
}
