#include <exec/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <exec/types.h>
#include <libraries/dos.h>
#include <libraries/dosextens.h>

#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/dlg.h>

#include <pragmas/dlg.h>

#define SOURCEFILE "DLGSerial.txt"
#define DESTFILE "DLGSerial.dat"

int main(int argc,char **argv)
{
   FILE *in;

   struct Library *DLGBase;

   DLGBase = OpenLibrary("dlg.library",2);
   if(!DLGBase) exit(15);

   in = fopen(SOURCEFILE,"r");

   if(in != NULL)
   {
      FILE *out;

      BOOL Valid = FALSE;

      char s[513];

      out = fopen(DESTFILE,"w");

      if(out == NULL)
      {
         printf("Destination file error!\n");

         fclose(in);
         CloseLibrary(DLGBase);
         exit(11);
      }

      while(fgets(s,512,in))
      {
         if(Valid)
         {
            char t[256];

            strmid(s,t,1,1);

            if(stricmp(t,"<"))
            {
               int Ser = 0;

               strmid(s,t,2,4);

               Ser = atoi(t);

               strmid(s,t,13,1);

               if(stricmp(t,"+"))
               {
                  if(Ser)
                  {
                     int Ver = 0;

                     strmid(s,t,10,1);

                     Ver = atoi(t);

                     if(Ver)
                     {
                        char *F,*M,*L,Name[256];

                        strmid(s,t,47,1);

                        if((strlen(s) > 47) && (strncmp(t,"-",1)))
                        {
                           strmid(s,t,48,strlen(s));
                           StripSpaces(t);
                           strcpy(Name,strtok(t,"\n"));
                        }
                        else
                        {

                           strmid(s,t,14,12);
                           StripSpaces(t);
                           L = strdup(strtok(t,"\n"));

                           strmid(s,t,26,10);
                           StripSpaces(t);
                           F = strdup(strtok(t,"\n"));

                           if(strlen(s) > 35)
                           {
                              strmid(s,t,36,11);
                              StripSpaces(t);
                              M = strdup(strtok(t,"\n"));
                           }
                           else
                           {
                              M = strdup('\0');
                           }

                           if(strlen(M) > 0)
                           {
                              sprintf(Name,"%s %s %s",F,M,L);
                           }
                           else
                           {
                              sprintf(Name,"%s %s",F,L);
                           }
                        }

                        fprintf(out,"%4.4ld     %ld         Y         %s\n",Ser,Ver,Name);
                     }
                  }
               }
            }
            else
            {
               printf("Deleted!\n");
            }

         }
         else
         {
            if(!strnicmp(s," ====",5))
            {
               Valid = TRUE;
            }
         }
      }

      fclose(out);
      fclose(in);
   }
   else
   {
      printf("Source file error!\n");
      CloseLibrary(DLGBase);
      exit(10);
   }

}
