#include <exec/types.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#include "clean.h"

#define INFILE "DLGSerial.dat"
#define OUT1 "owners.clean"
#define OUT2 "owners.h"

int counter=0;

encrypt(char *s,int leng)
{
   int i;
   int cnt=0;

   cnt=0;
   for(i=0;i<leng;i++)
   {
      s[i]^=encrypt1[cnt];
      cnt++;
      if(cnt>=strlen(encrypt1))
         cnt=0;
   }

   cnt=0;
   for(i=0;i<leng;i++)
   {
      s[i]^=encrypt2[cnt];
      cnt++;
      if(cnt>=strlen(encrypt2))
         cnt=0;
   }

   for(i=0;i<leng;i++)
   {
      s[i]^=encrypt3[counter];
   }
   counter++;
   if(counter>=strlen(encrypt3))
      counter=0;

   return 1;
}

struct vendors
{
   char *name;
   char *vendorid;
};

struct vendors v[]=
{
   "steve","Vendor 0",
   "(steve)","Vendor 0",
   "greg","Vendor 1",
   "(greg)","Vendor 1",
   "tony","Vendor 2",
   "(tony)","Vendor 2",
   "micropace","Vendor 3",
   "(micropace)","Vendor 3",
   "compbas","Vendor 4",
   "(compbas","Vendor 4",
   "",""
};

void checkforvendor(char *n)
{
   int i;

   for(i=0;*v[i].name;i++)
   {
      if(0==stricmp(n,v[i].name))
      {
         sprintf(n,"Still registered to %s",v[i].vendorid);
         break;
      }
   }
}

int stripendingspaces(char *n)
{
   int i;

   i=strlen(n);
   i--;
   while(n[i]==32)
   {
      n[i]=0;
      i--;
   }
   return (int)strlen(n);
}

main(void)
{
   char buf[100];
   FILE *in;
   FILE *out;
   FILE *enc;
   int records=0;
   char *r;
   int i,j;
   
   int serial;
   int version;
   int pdq;
   char name[80];

   char *vers[]={"","DLGv1","DLGv2"};
   char *pdqs[]={"PDQ=N","PDQ=Y"};

   printf("this program will open %s for input and generate\n",INFILE);
   printf("two files, %s and %s (which is encrypted)\n\n",OUT1,OUT2);

   if(in=fopen(INFILE,"r"))
   {
      if(out=fopen("T:1","w"))
      {
         while(fgets(buf,sizeof(buf),in))
         {
            r=strchr(buf,'\n');
            if(r) *r=0;
            r=strchr(buf,'\r');
            if(r) *r=0;

            if(*buf==0)
               continue;

            if(*buf==32)
               continue;

            records++;

            serial=atoi(buf);
            version=atoi(buf+9);
            if(*(buf+19)=='Y' || *(buf+19)=='y')
               pdq=1;
            else
               pdq=0;
            strcpy(name,buf+29);

            stripendingspaces(name);
            checkforvendor(name);            

            sprintf(buf,"%4d %5s %5s %-42s",serial,vers[version],pdqs[pdq],name);
            fprintf(out,"%s\n",buf);
            i=strlen(buf);
         }
         printf("strlen(buf)=%d+1\n",i);
         fclose(out);
         sprintf(buf,"sort from t:1 to %s",OUT1);
         system(buf);
         printf("There are %d owner records\n",records);


         out=fopen(OUT1,"r");
         if(out)
         {
            sprintf(buf,"copy clean.h %s",OUT2);
            system(buf);
            enc=fopen(OUT2,"a");
            if(enc)
            {
               fprintf(enc,"__far struct encrypted enc[]=\n{\n");

               while(fgets(buf,sizeof(buf),out))
               {
                  r=strchr(buf,'\n');
                  if(r) *r=0;
                  r=strchr(buf,'\r');
                  if(r) *r=0;

                  i=strlen(buf)+1;

                  encrypt(buf,i);

                  fprintf(enc,"    { ");

                  for(j=0;j<i;j++)
                     fprintf(enc,"%d,",buf[j]);

                  fprintf(enc," },\n");

               }
               fprintf(enc,"    { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, }\n");

               fprintf(enc,"};\n");

               fclose(enc);
            }
            fclose(out);
         }

      }
      fclose(in);
   }


}
