#include <exec/types.h>

#include <dos/dos.h>
#include <dos/dosextens.h>

#include <devices/tpt.h>

#include <proto/exec.h>

extern long                tptflags;

extern SHORT               num_kills;

extern   void  CheckPending(struct TPTSess *);
extern   void  FakeSerString(struct TPTSess *, UBYTE *, int);
extern   void  ReadSer(struct TPTSess *, unsigned short);
extern   void  returnpktplain(struct DosPacket *, struct Process *);
extern   void  TDebug(char *);


void                KillAux(struct TPTSess *);

///   Die()
BOOL                Die(struct TPTSess *sess)
{
   if (tptflags & T_KILL_ENABLE)
   {
      tptflags |= T_KILLED;
      tptflags &= ~T_PAUSED;

      if(!(tptflags & T_FROZEN) && ((tptflags & T_RPEND) || (tptflags & T_WAIT_FOR)))
      {
         KillAux(sess);
         CheckPending(sess);
      }

// debug
      TDebug("Die(): killed port");
// end debug
      return (TRUE);
   }

   if (tptflags & T_DO_PEND)  tptflags |= T_KILL_PEND;

// debug
   TDebug("Die() did not kill port due to pend directive");
// end debug

   return (FALSE);
}
//-
///   KillAux
/* Send ^C to reader task */
void                KillAux(struct TPTSess *sess)
{
   if (++num_kills < 50)
   {
      // We don't want to be paused now */
      if (tptflags & T_PAUSED) tptflags &= ~T_PAUSED;

      if (sess->creader)
      {
         Signal(sess->creader->task, SIGBREAKF_CTRL_C);
// debug
         TDebug("KillAux: Control-C Sent");
// end debug
      }

      if (tptflags & T_WAIT_FOR)
      {
         tptflags &= ~T_WAIT_FOR;
         sess->creader->rdpkt->dp_Res1 = DOS_FALSE;
         returnpktplain(sess->creader->rdpkt, sess->port->myproc);
      }
      else
      {
         ReadSer(sess, 13);
      }
   }
   else
   {
      num_kills = 0;
      FakeSerString(sess, "ENDCLI", 6);
      ReadSer(sess, 13);
// debug
      TDebug("KillAux: ENDCLI Sent");
// end debug
   }
}
//-


