FILEGUIDE
=========

FUNCTION

   Create an AmigaGuide list of files suitable for use by remote nodes for
   freqing, as well as usable by users to quickly find files of interest,
   and by sysops to organize thier files.  File lists generated by FileGuide
   consist of an opening "page" listing available file areas.  When the
   user clicks on a file area, a list of files in that file area are
   presented.  File names are AmigaGuide links.  Clicking on the file
   name of interest instantly generates a file request file in the user's
   OUTBOUND: directory if it exists.  The next time the user calls your
   BBS with TrapDoor, the file requests will be sent and the files
   (hopefully) will be sent in return.

   This concept was inspired by Roger Clarke's wonderful program Mercury,
   the multi-platform compiled Arexx program that many people have used
   with DLG.

   FileGuide, however, was written in conjunction with FileList for DLG
   2000, completely from scratch and optimized for use specificaly with
   DLG.


USE

   Can be used in any stdio environment, though it is recommended that it
   be used from a shell or batch file (such as a daily CronTab entry).


COMMAND TEMPLATE

   FileGuide -q -i <filename> -o <filename> [-l <level>] [-e] [-d <days>]
             [-f <pattern>] [-p <pattern>] [-m] -[-a <area list>]
             [-v <lines>] [-w <width>] [-> <size>] [-< <size>]

   -q    If this flag is specified, FileGuide does not report its progress
         to stdio. Error conditions are reported.

   -i <> This specifies a file to be used as an introduction. It will be
         prepended to the list at the head of the resulting output file.
         This is an optional parameter.

   -o <> This specifies the file that will be created. Program will not
         execute if this is not specified.

   -l <> If specified, this indicates what level to access the file
         database with.  File areas that are not accessable by this level
         of user will not be listed.  Also, file areas that are not
         auto-access will not be listed UNLESS the level specified is 255
         (sysop level).

   -e    If specified, this flag instructs the program to list files in
         areas regardless of whether they are freqable or not. Normally,
         the program restricts itself to areas that are freqable.

   -d <> If specified, FileGuide will only list files uploaded to the BBS
         in the last "x" days, where the argument following -d is the
         number of days to go back. This is useful to generate a "new
         files" list.

   -f <> These two flags spcify a pattern to search for in the filename,
   -p <> or the filename AND short description, respectively. If the
         pattern is matched, the file will be listed.

   -m    If this flag is specified, FileGuide will not list magic file
         names.

   -a <> If this flag is used, it must be followed by a list of areas to
         search.  Many formats are valid:

            "1 2 3"

         lists file areas 1 2 and 3.

            "1,2,3"

         does the same thing.

            "1-10"

         lists file areas 1 through 10 if they exist.

            "100+"

         lists all extant file areas numbering 100 and greater.

         All of the above formats can be combined, too.

            "1 10 100 150-200 900+"

         will list file areas 1, 10, 100, all file areas between 150 and
         200, and all file areas 900 and greater.

         If any spaces are used, the list must be included in quotes,
         otherwise it need not be.

   -v <> Use long descriptions.  If followed by a number, the number is
         how many lines to limit the long description to. A value of 0
         equals no limit.

         NOTE WELL: this method takes more than 7 times as long to
         generate a list of the same file areas!

   -w <> The width to limit the generated file to. Minimum acceptable
         value is 40, maximum is 132.  Only the file descriptions, divider
         bars, and centered text is affected.  File names and file sizes
         are not adjusted.

   -> <> List only files that are greater than (>) or less than (<) the
         specified size in bytes.

   Executing the program with no arguments, incorrect arguments, or
   missing arguments will cause it to display a command template and
   "beep" the user.

OUTPUT

   Creates a text file that contains a list of files.

   The file names are limited to 18 characters.  File names that exceed 18
   characters are followed by a * -- this conforms to DLGFreq's ability to
   understand * wildcards.  Filenames in generated REQ files are
   full-length.

   File sizes are restricted to 4 digits.  If the file size is less than
   10K, its size in bytes will be listed.  If it exceeds 10K but not 1M,
   the size will be expressed in Kbytes, with a trailing K. If the file
   size exceeds 1 Mb, the file size will be expressed in Mb, with a
   trailing M.

   Files are listed by file area, and sorted alphabetically within those
   areas.


BUGS

   None yet, but give Mike time ... :-)
