#include <exec/types.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <proto/dlg.h>

#include "header.h"

extern struct Library *DLGBase;

extern void *new(int);
extern void set_error_code(int,char *,char *);
extern void delete(void *);
extern void FixSlashes(char *);

struct area *create_area(char *areastring,char *name)
{
   char *p;
   struct area *a;
   char junk[100];

   a=new(sizeof(struct area));

   if(a==0)
      return(0);

   a->first_nodenum=0;
   a->next_area=0;
   a->passthru=default_passthru;
   a->link=default_link;
   a->alias=default_alias;
   a->areanum=atoi(areastring);
   a->class=default_class;

   /*
    * Build the path to the message base here... We won't really
    * concern ourself if it exists or not at this stage, that
    * is better handled in executables that use the path...
    * 
    */

   if(a->passthru)
   {
      p=stpcpy(a->path,"PASS:");
      a->areanum=0;
   }
   else
   {
      p=stpcpy(a->path,"MSG:");
   }
   
   /*
    * We want to detect a special case for passthru areas where the
    * path is created from the area name... look for "[DEF]" and
    * substitute the name for areastring
    */

   if(Stricmp(areastring,"[DEF]"))
   {
      if(strlen(areastring)+(p-(a->path))+1>=MAX_STR)
      {
         set_error_code(STRING_LEN,"DLGMail.ARE: Area Name is too long: ",areastring);
         delete(a);
         return(0); /* Error: path name will be too long. */
      }

      p=stpcpy(p,areastring);
      stpcpy(p,"/");
      a->path[MAX_STR-1]=0; /* Double Insurance that it gets null terminated. */
   }
   else
   {
      /***** [def] area *****/

      if(a->passthru==0)
      {
         set_error_code(STRING_LEN,"DLGMail.ARE: Can't use [DEF] name for local areas: ",name);
         delete(a);
         return(0);
      }

      if(strlen(name)+(p-(a->path))+1>=MAX_STR)
      {
         set_error_code(STRING_LEN,"DLGMail.ARE: Area Name is too long: ",areastring);
         delete(a);
         return(0); /* Error: path name will be too long. */
      }

      strcpy(junk,name);
      FixSlashes(junk);

      p=stpcpy(p,junk);
      stpcpy(p,"/");
   }

   Upper(a->path);

   /*
    * End of Steve's diddling for passthru paths...
    */

  strncpy(a->name,name,MAX_STR);
  Upper(a->name);    /* STEVE HACK FOR UPPERCASE TAGS */
  a->name[MAX_STR-1]=0;

  strncpy(a->from_organization,default_from_organization,MAX_STR);
  a->from_organization[MAX_STR-1]=0;
  a->from_zone=default_from_zone;
  a->from_net=default_from_net;
  a->from_node=default_from_node;
  a->from_point=default_from_point;
  a->description=0;

  return(a);
}

