#include "DLGtick.h"

#include <link/io.h>

/// TickMaint
BOOL TickMaint(void)
{
   BOOL  More = FALSE;

   BPTR  Lk = FALSE;

   char *s;

   struct   ExAllControl  *eac = NULL;
   struct   ExAllData     *ead = NULL;
   struct   ExAllData     *t   = NULL;
   struct   List          *FileL = NULL;
   struct   SearchCookie  *search = NULL;

   FileL = calloc(1,sizeof(struct List));

   if(!FileL) return(FALSE);

   NewList(FileL);

   t   = calloc(1,512);

   if(!t)
   {
      free(FileL);
      return(FALSE);
   }


   Lk = Lock("Tick:",ACCESS_READ);

   if(!Lk)
   {
      free(FileL);
      free(t);
      return(FALSE);
   }

   eac = AllocDosObject(DOS_EXALLCONTROL,NULL);

   if(!eac)
   {
      free(FileL);
      free(t);
      UnLock(Lk);
      return(FALSE);
   }

   eac->eac_LastKey = 0;

/// Fetch the names of all dirs in TICK:
   do
   {
      Chk_Abort();
      More = ExAll(Lk,t,512,ED_TYPE,eac);

      if (eac->eac_Entries == 0)
         continue;

      ead = t;

      do
      {
         Chk_Abort();

         if(ead->ed_Type > 0)
         {
            if(Stricmp(ead->ed_Name,"BAD"))
            {
               int Index;

               Index = GetEcho(ead->ed_Name);

///            Found a valid echo name, now we look inside it
               if(Index != -1)
               {
                  if(TicArea[Index].Purge == TRUE)
                  {
                     char     dir[500];
                     char    *file;
                     char     path[500];
                     struct   SearchCookie  *sc;

                     ASPrintf(NULL,dir,"Tick:%s",ead->ed_Name);

///                  Search each dir for files and add them.
                     sc = SearchStart(dir,"*");

                     while(file = SearchNext(sc))
                     {
                        struct Node *n;

                        Chk_Abort();

                        n = calloc(1,sizeof(struct Node));

                        if(!n) continue;

                        strmfn(path,NULL,dir,file,NULL);

//                        strcpy(path,dir);
//                        AddPart(path,file,499);

                        n->ln_Name = strdup(path);
                        AddTail(FileL,n);
                     }

                     SearchEnd(sc);
//-
                  }

               }
//-
            }

         }

         ead = ead->ed_Next;
      } while(ead);

   }  while(More);
//-

/// Determine which files are to be purged
   if(FileL)
   {
      if(!IsListEmpty(FileL))
      {
         search = SearchStart("Outbound:","*.*.*.*.?LO");

         while(s = SearchNext(search))
         {
            BPTR fh = NULL;
            char path[500];
            char queue[500];

            ASPrintf(NULL,path,"Outbound:%s",s);

            fh = Open(path,MODE_OLDFILE);

            if(!fh) continue;

            while(FGets(fh,queue,499))
            {
               char *f;
               struct Node *This;
               struct Node *Next;

               f = strdup(stpblk(strtok(queue,"\r\n")));

               This = FileL->lh_Head;

               while(Next = This->ln_Succ)
               {
                  Chk_Abort();

                  if(!Stricmp(This->ln_Name,f))
                  {
                     AFPrintf(NULL,sout,"Keeping %s\n",f);
                     Remove(This);
                     free(This);
                  }

                  This = Next;
               }
            }

            Close(fh);
         }

         SearchEnd(search);
      }
   }
//-

/// Delete files
   if(FileL)
   {
      if(!IsListEmpty(FileL))
      {
         struct Node *This;
         struct Node *Next;

         This = FileL->lh_Head;

         while(Next = This->ln_Succ)
         {
            Chk_Abort();
            AFPrintf(NULL,sout,"Purging %s\n",This->ln_Name);
            ASPrintf(NULL,logstring,"   Purging %s",This->ln_Name);
            Log(logstring);
            DeleteFile(This->ln_Name);
            This = Next;
         }
      }
   }
//-

/// Free list of files
   if(FileL)
   {
      if(!IsListEmpty(FileL))
      {
         struct Node *This;
         struct Node *Next;

         This = FileL->lh_Head;

         while(Next = This->ln_Succ)
         {
            Chk_Abort();
            free(This);
            This = Next;
         }
      }

      free(FileL);
   }
//-

   UnLock(Lk);
   free(ead);
   FreeDosObject(DOS_EXALLCONTROL,eac);

   return(TRUE);
}
//-

