#include "Includes.h"
#include "Defines.h"
#include "Protos.h"
#include "Version.h"
#include "Vars.h"

#include <link/io.h>

/// __QUICKATTACH
int __QUICKATTACH(int argc, char **argv)
{
   char *suppliedfullpathname;
   int dzone=0,dnet=0,dnode=0,dpoint=0;
   char device[30];
   char subdirs[100];
   char filename[40];
   char extension[20];
   int mode,oldmode,i,j;
   BOOL flag;
   BPTR fp;
   char string[40];
   char tmp[40];
   char str[100];
   char prepend[10];

   strcpy(prepend,"");

   suppliedfullpathname=argv[0];

   strsfn(suppliedfullpathname,device,subdirs,filename,extension);

   if(0==Strnicmp(device,"OUTBOUND",8))
      strcpy(prepend,"^");

   strcat(subdirs,"/");

   if(*extension)
   {
      strcat(filename,".");
      strcat(filename,extension);
   }

   /* theoretically, we can search several paths for the file to attach */

   CP_CommandLine(4,"QUICKATTACH: Attach request [%s]",suppliedfullpathname);

   if(Exists(suppliedfullpathname))
   {
      mode=0;
      for(i=1;i<argc;i++)
      {
         flag=FALSE;

         if(0==Stricmp(argv[i],"HOLD"))      { mode=1;flag=TRUE; }
         if(0==Stricmp(argv[i],"CRASH"))  { mode=2;flag=TRUE; }
         if(0==Stricmp(argv[i],"DIRECT"))    { mode=3;flag=TRUE; }
         if(0==Stricmp(argv[i],"NORMAL"))    { mode=4;flag=TRUE; }
         if(0==Stricmp(argv[i],"EXISTING"))  { mode=5;flag=TRUE; }

         if(mode==0)
         {
            CP_CommandLine(4,"No file attach flavor found for [%s]",suppliedfullpathname);
            break;
         }

         if(flag) continue;

         /* argv[i] = an address */
         
         NumStrsfn(argv[i],&dzone,&dnet,&dnode,&dpoint);

         if(dzone==0) dzone=_MyZone;

         ASPrintf(NULL,string,"%ld.%ld.%ld.%ld.",dzone,dnet,dnode,dpoint);

         oldmode=mode;

         if(oldmode==5) oldmode=1;

         for(j=oldmode;j<5;j++)
         {
            strcpy(tmp,string);
            switch(j)
            {
               case 1:
               strcat(tmp,"HLO");
               break;

               case 2:
               strcat(tmp,"CLO");
               break;

               case 3:
               strcat(tmp,"DLO");
               break;

               case 4:
               strcat(tmp,"FLO");
               break;
            }

            ASPrintf(NULL,str,"OUTBOUND:%s",tmp);

            if(mode!=5) break;
            if(mode==5 && Exists(str)) break;
         }

         fp=Open(str,MODE_READWRITE);

         if(fp)
         {
            Seek(fp,0,OFFSET_END);
            CP_CommandLine(4,"Attaching [%s] to [%s] in [%s]",filename,argv[i],tmp);
            AFPrintf(NULL,fp,"%s%s\n",prepend,suppliedfullpathname);
            Close(fp);
         }
         else
         {
            CP_CommandLine(4,"Couldn't open [%s] to attach file [%s]",str,suppliedfullpathname);
         }
      }
   }
   else
   {
      Delay(75);
      CP_CommandLine(4,"File not found");
   }
   return 1;
}
//-

/// __QUICKREQUEST
int __QUICKREQUEST(int argc, char **argv)
{
   BPTR fp;
   char filename[100];
   int i;
   int dzone,dnet,dnode,dpoint;

   
   if(argc>1)
   {
      NumStrsfn(argv[0],&dzone,&dnet,&dnode,&dpoint);

      if(dzone==0) dzone=_MyZone;
   
      ASPrintf(NULL,filename,"OUTBOUND:%ld.%ld.%ld.%ld.REQ",dzone,dnet,dnode,dpoint);
   
      CP_CommandLine(4,"QUICKREQUEST: Requesting files from [%ld:%ld/%ld.%ld]",dzone,dnet,dnode,dpoint);

      fp=Open(filename,MODE_READWRITE);
      if(fp)
      {
         Seek(fp,0,OFFSET_END);
         for(i=1;i<argc;i++)
         {
            AFPrintf(NULL,fp,"%s",argv[i]);
            strcpy(filename,argv[i]);

            if((i+1)<argc)
            {
               if(*argv[i+1]=='!')
               {     
                  i++;
                  AFPrintf(NULL,fp," %s",argv[i]);
               }
            }
            AFPrintf(NULL,fp,"\r\n");

            CP_CommandLine(4,"Requesting [%s]",filename);
            Delay(75);
         }
         Close(fp);
      }
      else
      {
         Delay(75);
         CP_CommandLine(4,"Couldn't open [%s] for file requests",filename);
      }
   }
   else
   {
      CP_CommandLine(4,"Incorrect or missing arguments for QuickRequest");
   }
   return(1);
}
//-

