#include "zmiglobals.h"

#include <link/io.h>

/* Globals */

BPTR LockFile;
char packets[100][50];

/********************************/

/// CheckDLGMAILSTOP
int CheckDLGMAILSTOP()
{
   if(Exists("Env:DLGMailSTop"))
   {
      Log(". DLGMail told me to stop processing packets");
      return 1;
   }

   return 0;
}
//-

/// TossPackets
int TossPackets()
{
   char datestamp[50];

   int i;
   int j;
   char *pkts[100];
   int type;
   char *filename;


   if(_VERBOSITY>2) Log("-> Begin TossPackets()");

   LockFile=Lock("INBOUND:",ACCESS_READ);

   if(LockFile)
   {
      i=Examine(LockFile, FIB);

      if(i)
      {
         j=0;

         while(j<99)
         {
            type=FIB->fib_DirEntryType;
            filename=FIB->fib_FileName;
            Upper(filename);

            if(type<0 && (DLGPatternMatch("????????.PKT",filename)))
            {
               /*build datestamp here */

               sprintf(datestamp,"%06X%06X%06X",
                  FIB->fib_Date.ds_Days,
                  FIB->fib_Date.ds_Minute,
                  FIB->fib_Date.ds_Tick);

               ASPrintf(NULL,packets[j],"%s %s",datestamp,filename);

               if(MyDEBUG) AFPrintf(NULL,sout,"remembering %s\n",packets[j]);

               pkts[j]=packets[j];
               j++;
            }

            i=ExNext(LockFile,FIB);
            if(!i) break;
         }

         if(j>0)
         {
            AFPrintf(NULL,sout,"\nThere are %d .PKT's - Processing in CHRONOLOGICAL Order          \n",j);
            tqsort(pkts,j);

            for(i=0;i<j;i++)
            {
               if(CheckDLGMAILSTOP()) break;

               if(_VERBOSITY>1)
               {
                  ASPrintf(NULL,logstring,". Tossing %s (Date code:%18.18s)",pkts[i]+19,pkts[i]);
                  Log(logstring);
               }

               if(MyDEBUG>1) AFPrintf(NULL,sout,"Processing: [33m%s[0m\n",pkts[i]+19);

               tzmain(pkts[i]+19,i+1,j);

               if(_VERBOSITY>1) Log("<- End of packet processing");
            }
         }
         else
         {
            if(MyDEBUG) AFPrintf(NULL,sout,"No more .PKT's found\n");
         }
      }

      if(_VERBOSITY>2 )
         Log("<- End TossPackets()");

      UnLock(LockFile);
      return(j);
   }
   else
   {
      Log("! ERROR: Can't lock INBOUND:, ending TossPackets()");
      AFPrintf(NULL,sout,"Can't get a lock on INBOUND: to get a directory of .PKT's\n");
      return(-100);
   }
}
//-

/// FindOldestBundle
int FindOldestBundle(char *bundle)
{
   char datestamp[50];
   int rc=0;

   int i;
   int j;
   char *pkts[100];
   int type;
   char *filename;
   BOOL matchflag;

   strcpy(ARCpat[0],"????????.SU?");
   strcpy(ARCpat[1],"????????.MO?");
   strcpy(ARCpat[2],"????????.TU?");
   strcpy(ARCpat[3],"????????.WE?");
   strcpy(ARCpat[4],"????????.TH?");
   strcpy(ARCpat[5],"????????.FR?");
   strcpy(ARCpat[6],"????????.SA?");

   LockFile=Lock("INBOUND:",ACCESS_READ);

   if(LockFile)
   {
      i=Examine(LockFile, FIB);

      if(i)
      {
         j=0;

         while(j<99)
         {
            type=FIB->fib_DirEntryType;
            filename=FIB->fib_FileName;

            Upper(filename);

            if(type<0)
            {
               matchflag=FALSE;

               for(i=0;i<7;i++)
               {
                  if(DLGPatternMatch(ARCpat[i],filename))     // && filename[11]<'G')
                  {
                     matchflag=TRUE;
                     break;
                  }
               }

               if(matchflag)
               {
                  /*build datestamp here */

                  sprintf(datestamp,"%06X%06X%06X",
                     FIB->fib_Date.ds_Days,
                     FIB->fib_Date.ds_Minute,
                     FIB->fib_Date.ds_Tick);

                  ASPrintf(NULL,packets[j],"%s %s",datestamp,filename);

                  pkts[j]=packets[j];
                  j++;
               }
            }
            i=ExNext(LockFile,FIB);

            if(!i) break;
         }

         if(j>0)
         {
            tqsort(pkts,j);
            strcpy(bundle,pkts[0]+19);
            rc=1;
         }
         else
         {
            strcpy(bundle,"");
            rc=0;
         }
      }

      ASPrintf(NULL,logstring,". Oldest bundle is [%s]",bundle);
      Log(logstring);

      UnLock(LockFile);
      return(rc);
   }
   else
   {
      Log("! ERROR: Can't lock INBOUND:, ending FindOldestBundle()");
      AFPrintf(NULL,sout,"Can't get a lock on INBOUND: to get a directory of bundles\n");
      return(0);
   }
}
//-

