#include <exec/types.h>
#include <stdio.h>
#include <libraries/dos.h>
#include <dos.h>
#include <proto/dos.h>
#include "zexport.h"

#include <link/io.h>

/* these routines appear to be friendly to ross code */

struct HiWater MyHiWater;

/// ExportTheArea
int ExportTheArea()  /* <==== FROM ALOOP.C */
{

   /* info regarding the msg area to be packaged up is contained in
      the following global variables:

   MSGAREATAG
   MSGAREANUMBER
   MSGAREAPATH
   MSGAREAPASSTHRU

   Access these globals to find out who/what/where/when */

   BPTR POINTERfile;

   int j;

   int lo,hi;
   int oldHW;

   char tempstring[300];
   char otherstring[300];

   for(;;)
   {
      MyBorrowArea(MSGAREANUMBER);

      if(*MSGAREAPATH==NULL)
         Log("*! *MSGAREAPATH is NULL <ExportTheArea();> <A>");

      ASPrintf(NULL,tempstring,"%sPOINTERS.MSG",MSGAREAPATH);

      POINTERfile=Open(tempstring,MODE_OLDFILE);

      if(!POINTERfile)
      {
         if(MyDEBUG) AFPrintf(NULL,sout,"ERROR: No %s\n",tempstring);
         UnBorrowArea(MSGAREANUMBER);
         AFPrintf(NULL,sout,"[33mNew area? No POINTERS.MSG file - Nothing to export[0m\n\n");
         break;
      }

      FGets(POINTERfile,otherstring,10);
      lo=atoi(otherstring);
      FGets(POINTERfile,otherstring,10);
      hi=atoi(otherstring);

      Close(POINTERfile);

      UnBorrowArea(MSGAREANUMBER);

      if(MyDEBUG) AFPrintf(NULL,sout,"[33mLO=%d,HI=%d\n[0m",lo,hi);

/*DELAY     Delay(5);*/
   
      oldHW=FetchHW(MSGAREAPATH,MSGAREANUMBER);

      if(oldHW==0) oldHW=lo-1;

      if(oldHW<2) oldHW=1;

      if(oldHW==hi)
      {
         AFPrintf(NULL,sout,"\n");

         if(_VERBOSITY)
            Log(" . Area Exported and Current");

         break;
      }

/* ===> */
      j=PackMsgs(oldHW+1,hi); /* <=== LINKS TO R_SEENBY.C */

      if(j)
      {
         if(StoreHW(MSGAREAPATH,MSGAREANUMBER,hi)<1)
         {
            AFPrintf(NULL,sout,"ERROR: Problem storing HiWater pointer\n");
            break;
         }
      }
   }

   return(0);
}
//-
/// FetchHW
int FetchHW(char *path, long areanum)
{
   BPTR HIWATERfile;
   int i,j;
   char string[512];

   MyBorrowArea(areanum);

   ASPrintf(NULL,string,"%s1.MSG",path);

   HIWATERfile=Open(string,MODE_OLDFILE);

   if(!HIWATERfile)
   {
      if(MyDEBUG) AFPrintf(NULL,sout,"Can't open %s to retrieve hiwater mark\n",string);

      UnBorrowArea(areanum);
      return(0);
   }

   i=Read(HIWATERfile,(void *)&MyHiWater,sizeof(struct HiWater));

   Close(HIWATERfile);
   UnBorrowArea(areanum);

   j=MyHiWater.HiWater1;

   if(MyDEBUG) AFPrintf(NULL,sout,"---> Hiwater reported as %d\n",j);

   return(j);
}
//-
/// StoreHW
int StoreHW(char *path, long areanum, int hiwater)
{
   BPTR HIWATERfile;

   int i,j;

   char string[512];
   char buffer[100];

   MyBorrowArea(areanum);

   ASPrintf(NULL,string,"%s1.MSG",path);

   HIWATERfile=Open(string,MODE_NEWFILE);

   if(!HIWATERfile)
   {
      AFPrintf(NULL,sout,"Can't open %s to store hiwater mark\n",string);
      UnBorrowArea(areanum);
      return(0);
   }

   strcpy(MyHiWater.From,"DLGExp");
   strcpy(MyHiWater.To,"DLGExp");

   ASPrintf(NULL,buffer,"DLGExp HiWater Marker being set to %d",hiwater);

   strcpy(MyHiWater.Title,buffer);
   MyHiWater.HiWater1=hiwater;
   MyHiWater.HiWater2=hiwater;
   MyHiWater.HiWater3=hiwater;
   strcpy(MyHiWater.Text,"NOECHO\r\n\r\nIgnore this message. Used to store the area Hi Water Mark for DLGExp\r\n");

   j=MyHiWater.HiWater1;

   i=Write(HIWATERfile,(void *)&MyHiWater,sizeof(struct HiWater));

   if(i!=sizeof(struct HiWater))
   {
      AFPrintf(NULL,sout,"May have been a problem storing hi water marker\n");
      j=j*-1;
   }

   Close(HIWATERfile);
   UnBorrowArea(areanum);

   if(MyDEBUG) AFPrintf(NULL,sout,"---> Hiwater returned as %d\n",j);

   return(j);
}
//-
