#include <exec/types.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>

#include <DLG/GlobalConfig.h>
#include "/dlgmail/gc_parse.h"

#include <proto/dlg.h>
#include <pragmas/dlg.h>

#include <link/io.h>

#include <proto/exec.h>
#include <proto/dos.h>

#include <private/Version.h>
#define  ObjRev "1"
const UBYTE version[]="\0$VER: DLGMail ConfigHelper " BUILDVER "." ObjRev " " COPYRIGHT " by Digerati Dreams "__AMIGADATE__;

int printhelp(char *);

BPTR sout;

struct Library *DLGBase;

int main(int argc, char **argv)
{
   int i,handler,mandatory;

   sout = Output();

   DLGBase = OpenLibrary("dlg.library",2L);

   AFPrintf(NULL,sout,"Here's what DLGMail is looking for in the .CFG file:\n\n");

   for(i=0;*gcp[i].gcp_keyword;i++)
   {
      Chk_Abort();

      handler=gcp[i].gcp_handler;

      mandatory=gcp[i].gcp_flag_mandatory;

      AFPrintf(NULL,sout,"%-20.20s ",gcp[i].gcp_keyword);

      if(gcp[i].gcp_flag_string)
      {
         if(*gcp[i].gcp_default_string)
            AFPrintf(NULL,sout,"%s \n\n",gcp[i].gcp_default_string);
         else
            AFPrintf(NULL,sout,"<no default supplied>\n\n");
      }
      else
      {
         if(gcp[i].gcp_default_numeric != -1)
            AFPrintf(NULL,sout,"%d \n\n",gcp[i].gcp_default_numeric);
         else
            AFPrintf(NULL,sout,"<defaults to another setting. see instructions>\n\n");
      }
      AFPrintf(NULL,sout,"       Setting: ");

      switch(mandatory)
      {
         default:
         AFPrintf(NULL,sout,"Will default to the above value if not specified");
         break;

         case GCP_MANDATORY:
         AFPrintf(NULL,sout,"[7m ***MANDATORY***[0m");
         break;

         case GCP_INTERNAL:
         AFPrintf(NULL,sout,"[7m *INTERNALLY MODIFIED*[0m");
         break;

         case GCP_OVERRIDE:
         AFPrintf(NULL,sout,"[7m *OVERRIDEABLE*[0m");
         break;
      }

      AFPrintf(NULL,sout,"\n     Processed: ");




      switch(handler)
      {
         default:
         AFPrintf(NULL,sout,"The value specified is substituted for the default");
         break;

         case HND_CALLTYPES:
         AFPrintf(NULL,sout,"Parsed to a string equal to exactly 24 characters");
         break;

         case HND_DEBUG:
         AFPrintf(NULL,sout,"The value of DB_ALL is used as default");
         break;

         case HND_NOLOG:
         AFPrintf(NULL,sout,"The value of LOG_ALL is used as default");
         break;

         case HND_STEALTH:
         AFPrintf(NULL,sout,"The value of PROCESSWINDOW is used as default");
         break;

         case HND_ADDRESS:
         AFPrintf(NULL,sout,"The address is parsed for proper 4D form, used elsewhere");
         break;

         case HND_POINTNET:
         AFPrintf(NULL,sout,"The address is parsed for proper 4D form, used elsewhere");
         break;

         case HND_AKA:
            AFPrintf(NULL,sout,"The first 32 AKA's are accepted only");
            break;

         case HND_ORIGIN:
         AFPrintf(NULL,sout,"The origin preface and address is added by the system");
         break;

         case HND_OPERATOR:
         AFPrintf(NULL,sout,"Check spelling");
         break;

         case HND_TEAR:
         AFPrintf(NULL,sout,"This string is built internally");
         break;
      }

      if(*gcp[i].gcp_instructions)
         AFPrintf(NULL,sout,"\n\n");

         printhelp(gcp[i].gcp_instructions);

      AFPrintf(NULL,sout,"\n---------------------------------------------------------------------------\n");
   }

   if(DLGBase) CloseLibrary(DLGBase);
}

#define maxl 65

printhelp(char *str)
{
   char string[300];

   char *s;
   char *p;

   if(*str==NULL) return 1;

   strcpy(string,str);

   p=string;

   while(1)
   {
      if(strlen(p)<maxl)
      {
         AFPrintf(NULL,sout,"  [7m%s[0m\n",p);
         break;
      }
      else
      {
         s=p;
         s+=maxl;

         for(;*s!=' ';s--)
            ;
         *s=NULL;
         AFPrintf(NULL,sout,"  [7m%s[0m\n",p);
         p=s+1;
      }
   }
   return 1;
}
