/* MODIFIED FOR EMACSDLG - EMBEDDED FUNCTION - CONVERT TO AMIGADOS I/O */

/*
** Copyright (c) 1983 Regents of the University of California.
** All rights reserved.
**
** Redistribution and use in source and binary forms are permitted
** provided that the above copyright notice and this paragraph are
** duplicated in all such forms and that any documentation,
** advertising materials, and other materials related to such
** distribution and use acknowledge that the software was developed
** by the University of California, Berkeley.  The name of the
** University may not be used to endorse or promote products derived
** from this software without specific prior written permission.
** THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
** IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
** WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 ****************************************************************************/

#include "Include.h"

/* ENC is the basic 1-character encoding function to make a char printing */
#define ENC(c) ((c) ? ((c) & 077) + ' ': '`')
#define UUBUFCHECK 1024

// Local functions
int outdec(char *, BPTR);
int encode(BPTR, BPTR);

/// uunecessary()
/*
** Read first part of file, decide if it is binary
** Return 1 if binary, else 0.
 *****************************************************/
int uunecessary(char *infile)
{
    BPTR in;
    char buf[UUBUFCHECK];
    int i;
    int n;
    int ch;
    
    if ((in = Open(infile, MODE_OLDFILE)) == NULL) {
   return 0;
    }
    n = FRead(in, buf, 1, UUBUFCHECK);
    Close(in);

    if (n == 0) return 0;
    for (i=0; i<n; ++i) {
   ch = buf[i] & 0x0ff;
   if (ch < 32) {
       /* ^G ^H ^I ^J ^L ^M ^Z */
       if (ch == 7 || ch == 8 || ch == 9 || ch == 10 || ch == 12 || ch == 13 || ch == 26) continue;
       return 1;
   }
   if (ch >= 127 && ch <= 160) return 1;
    }
    return 0;
}
//-

/// uuencode()
int uuencode(char *infile, char *outfile)
{
    BPTR out;
    BPTR in;
    char bname[120];

    if ((in = Open(infile, MODE_OLDFILE)) == NULL) {
   return -1;
    }
    if ((out = Open(outfile, MODE_NEWFILE)) == NULL) {
   Close(in);
   return -1;
    }

    FPuts(out, "begin 644 ");
    FPuts(out, makename(bname, infile));
    FPuts(out, "\n");

    if (encode(in, out) != 0) {
   Close(in);
   Close(out);
   return -1;
    }

    FPuts(out, "end\n");

    Close(out);
    Close(in);

    return 0;
}
//-

// Local functions

/// outdec()
/*
** output one group of 3 bytes, pointed at by p, on file f.
 **************************************************************/
int outdec(char *p, BPTR f)
{
   register int c1, c2, c3, c4;

   c1 = *p >> 2;
   c2 = (*p << 4) & 060 | (p[1] >> 4) & 017;
   c3 = (p[1] << 2) & 074 | (p[2] >> 6) & 03;
   c4 = p[2] & 077;
   FPutC(f, ENC(c1));
   FPutC(f, ENC(c2));
   FPutC(f, ENC(c3));
   FPutC(f, ENC(c4));

   return(1);
}
//-

/// encode()
/*
** copy from in to out, encoding as you go along.
 *****************************************************/
int encode(BPTR in, BPTR out)
{
   char buf[80];
   register int i, n;

   for (;;) {
      /* 1 (up to) 45 character line */
      n = FRead(in, buf, 1, 45);
      if (FPutC(out, ENC(n)) == EOF) return EOF;

      for (i=0; i<n; i += 3) {
          if (outdec(&buf[i], out) == EOF) return EOF;
      }

      if (FPutC(out, '\n') == EOF) return EOF;
      if (n <= 0)
         break;
   }
   return 0;
}
//-


