#include <time.h>
#include <ctype.h>
#include <string.h>

#include <exec/types.h>

#include <libraries/dosextens.h>

#include <devices/tpt.h>

#include <proto/exec.h>
#include <proto/dlg.h>
#include <proto/dos.h>

#include <pragmas/dlg.h>

extern struct DosLibrary *DOSBase;

BOOL  __saveds __asm LIBDB   (register __a0 char *);
LONG  __saveds __asm LIBTKill(register __a0 char *);
ULONG __saveds __asm LIBAmigaTime(void);


/// SendCtlMsg
LONG __saveds __asm LIBSendCtlMsg(register __d0 LONG mod,
                                  register __d1 LONG aux_stat,
                                  register __a0 char *devname)

{struct MsgPort   *ctrl_port;
 struct MsgPort   *myport;
 struct ctrl_mess  ctl_msg;

 unsigned char     tctl[11];

 tctl[0] = toupper(*devname);
 tctl[1] = toupper(*(devname+1));
 tctl[2] = toupper(*(devname+2));
 strcpy(&tctl[3], "control");

 Forbid();
 ctrl_port = FindPort(tctl);
 Permit();
 if (!ctrl_port)  return(ACTIVERR);

 myport = CreateMsgPort();
 if (!myport)  return(GENERALERR);

 ctl_msg.cmess.mn_Node.ln_Type = NT_MESSAGE;
 ctl_msg.cmess.mn_ReplyPort    = myport;
 ctl_msg.cmess.mn_Length       = sizeof(struct ctrl_mess);
 ctl_msg.mod_type              = mod;
 ctl_msg.astat                 = aux_stat;

 PutMsg(ctrl_port, (struct Message *)&ctl_msg);

 while(!GetMsg(myport))
        WaitPort(myport);
 DeleteMsgPort(myport);

 return(ctl_msg.astat);
}
//-

LONG __saveds __asm LIBTSetFlags(register __d0 ULONG flags,
                                 register __a0 char *devname)

{return(LIBSendCtlMsg(TADDSTAT,(LONG)flags,devname));
}


LONG __saveds __asm LIBTUnSetFlags(register __d0 ULONG flags,
                                   register __a0 char *devname)

{return(LIBSendCtlMsg(TDELSTAT,(LONG)flags,devname));
}


LONG __saveds __asm LIBTBaud(register __d0 LONG baud,
                             register __a0 char *devname)

{return(LIBSendCtlMsg(TBAUD,baud,devname));
}


LONG __saveds __asm LIBTColors(register __a0 USHORT *colortable,
                               register __a1 char   *devname)

{return(LIBSendCtlMsg(TCOLORS,(LONG)colortable,devname));
}


LONG __saveds __asm LIBTCont(register __a0 char *devname)

{return(LIBSendCtlMsg(TCONT,0,devname));
}


LONG __saveds __asm LIBTDevQuery(register __a0 struct tdev_info *devstruct,
                                 register __a1 char             *devname)

{return(LIBSendCtlMsg(TDEVQUERY,(LONG)devstruct,devname));
}


LONG __saveds __asm LIBTFreeze(register __a0 char *devname)

{return(LIBSendCtlMsg(TFREEZE,0,devname));
}


LONG __saveds __asm LIBTGetSer(register __a0 struct TPTSerStuff *serstruct,
                               register __a1 char               *devname)

{return(LIBSendCtlMsg(TGETSER,(LONG)serstruct,devname));
}


LONG __saveds __asm LIBTGetTitle(register __a0 char *title,
                                 register __a1 char *devname)

{return(LIBSendCtlMsg(TGETTITLE,(LONG)title,devname));
}


LONG __saveds __asm LIBTKill(register __a0 char *devname)

{return(LIBSendCtlMsg(TKILL,0,devname));
}


LONG __saveds __asm LIBTRecover(register __a0 char *devname)

{return(LIBSendCtlMsg(TRECOVER,0,devname));
}


LONG __saveds __asm LIBTScreen(register __d0 LONG              mod,
                               register __a0 struct ScrStruct *scrstruct,
                               register __a1 char             *devname)

{if (mod != TPOPSCREEN  &&  mod != TCLOSESCREEN)  return(GENERALERR);
 return(LIBSendCtlMsg(mod,(LONG)scrstruct,devname));
}


LONG __saveds __asm LIBTString(register __a0 char *string,
                               register __a1 char *devname)

{return(LIBSendCtlMsg(TSTRING,(LONG)string,devname));
}


LONG __saveds __asm LIBTTimeDelay(register __d0 LONG  delay,
                                  register __a0 char *devname)

{return(LIBSendCtlMsg(TTIMEOUTDELAY,delay,devname));
}


LONG __saveds __asm LIBTTitle(register __a0 char *title,
                              register __a1 char *devname)

{return(LIBSendCtlMsg(TTITLE,(LONG)title,devname));
}


LONG __saveds __asm LIBTWindow(register __d0 LONG              mod,
                               register __a0 struct WinStruct *winstruct,
                               register __a1 char             *devname)

{if (mod != WOPEN  &&  mod != WCLOSE)  return(GENERALERR);
 return(LIBSendCtlMsg(mod,(LONG)winstruct,devname));
}


LONG __saveds __asm LIBTWinHeight(register __a0 char *height,
                                  register __a1 char *devname)

{return(LIBSendCtlMsg(TWINHEIGHT,(LONG)height,devname));
}


LONG __saveds __asm LIBTInTrans(register __a0 char *trans,
            register __a1 char *devname)

{return(LIBSendCtlMsg(TINTRANS,(LONG)trans,devname));
}


LONG __saveds __asm LIBTOutTrans(register __a0 char *trans,
                                 register __a1 char *devname)

{return(LIBSendCtlMsg(TOUTTRANS,(LONG)trans,devname));
}

/// TCheckCarrier()
LONG __saveds __asm LIBTCheckCarrier(register __a0 char *devname)
{
   return(LIBSendCtlMsg(TCHECKCARRIER,0,devname));
}
//-

LONG __saveds __asm LIBTSendBreak(register __a0 char *devname)

{return(LIBSendCtlMsg(TSENDBREAK,0,devname));
}
