#include <exec/types.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <time.h>

#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/dlg.h>

#include <dlg/user.h>

#include <pragmas/dlg.h>

/// Old NameStruct
struct OldNameStruct
{
   char name[30];
   char Dummy[90];
};
//-

/// Old user data
struct Old_User
{
  char    Password[12];     /* users password                              */
  char    Screen_Len;       /* length of screen                            */
  char    Screen_Width;     /* width of screen                             */
  UBYTE   Ansi_Flag;        /* ansi flag (see defines)                     */
  char    More_Flag;        /* more flag (1=YES 0=NO)                      */
  char    Help_Level;       /* 0=Novice 1=Intermediate 2=Expert            */
  char    Alias[36];        /* alias                                       */
  char    Computer_Type;    /* number designating computer type            */
  SHORT   Daily_Limit;      /* daily call limit in minutes                 */
  SHORT   Session_Limit;    /* single session limit in minutes             */
  SHORT   Daily_Used;       /* amount of time used on last date logged in  */
  char    Bulletin_Access;  /* user can write bulletins ((1=YES 0=NO)      */
  char    send;             /* send protocol number                        */
  char    receive;          /* receive protocol number                     */
  UBYTE   msgsig;           /* last message sig the user was in            */
  UBYTE   filesig;          /* last file sig the user was in               */
  char    archiver;         /* number of default archiver (0=none)         */
  char    menuset;          /* number of default menu set                  */
  char    fileorder;        /* last selection for file list order          */
  char    filesince;        /* last selection for file search item         */
  char    charset;          /* users selected character set                */
  char    Temp_Filler[7];   /* not used                                    */
  char    Birth_Year;       /* year of birth - 1900 (eg 56 = 1956)         */
  long    Last_Area;        /* last message area user visited              */
  SHORT   User_Level;       /* users level                                 */
  char    Lex_Flag;         /* lex checking flag (1=YES 0=NO)              */
  char    Editor;           /* default message editor                      */
  char    Private_Flag;     /* not used                                    */
  char    Last_Login[27];   /* text string denoting last login date/time   */
  char    Ratio;            /* number denoting users upload download ratio */
  UBYTE   NetMail;          /* netmail access flag (see defines)           */
  char    ThreadMode;       /* last threadmode setting                     */
  char    Phone[15];        /* telephone number                            */
  char    City[24];         /* city                                        */
  char    Prov[6];          /* province/state                              */
  char    Pop_Screen;       /* pop screen for this user (1=YES 0=NO)       */
  char    Hot_Keys;         /* hot key flag (1=YES 0=NO)                   */
  long    Total_Calls;      /* total calls this user has made              */
  long    Online_Time;      /* total number of minutes spent online        */
  long    Messages_Entered; /* number of messages user has entered         */
  long    Messages_Read;    /* number of messages read online              */
  ULONG   Bytes_Uploaded;   /* number of bytes uploaded                    */
  ULONG   Bytes_Downloaded; /* number of bytes downloaded                  */
  long    Files_Uploaded;   /* number of files uploaded                    */
  long    Files_Downloaded; /* number of files downloaded                  */
  long    Sysop_Pages;      /* number of sysop pages                       */
  char    Address[26];      /* street address                              */
  char    Birth_Month;      /* month of birth                              */
  char    Birth_Day;        /* date of birth                               */
  long    Last_File_Area;   /* last file area visited                      */
  char    stack[40];        /* login command stack                         */
  char    UUCP;             /* uucp flag (see below)                       */
  char    Country[25];      /* country of origin                           */
  ULONG   Long_Date;        /* manx encoded long of date/time of last/current login */
  SHORT   DirLimit;         /* number of bytes allowed in private directory */
  SHORT   credit;           /* amount of netmail credit                    */
  char    postal[8];        /* postal code                                 */
  char    protocol;         /* not used                                    */
  char    captureflags;     /* default capture flag settings               */
  long    DateJoined;       /* date of first application (manx encoded long) */
};


//-

static char version[]="$VER: ConvertTemplete 1.2  1997 by DLG Development "__AMIGADATE__"";

BPTR  sout;
BPTR  fh =  NULL;

struct OldNameStruct *ONS = NULL;

struct NameStruct *NNS = NULL;

struct   Library    *DLGBase  =  NULL;

void  ShutDown(int, char *);
void  Usage(void);
void _CXBRK(void);

/// Main
int main(int argc, char **argv)
{
   BPTR    fh = NULL;
   ULONG   size = 0;
   long    limit;

   struct OldNameStruct *ns;

   struct Old_User   old;
   struct USER_DATA  new_u;

   SHORT i;

   sout = Output();

   DLGBase = OpenLibrary("dlg.library",2L);

   if(!DLGBase) ShutDown(10,"Could not open dlg.library!");
   if(-1 == FileSize("DLGConfig:Template/template",&size)) ShutDown(5,"No templates");

   ONS = calloc(1,size);

   if(!ONS) ShutDown(10,"Not enough memory");

   if(-1 == GetFirstStruct("DLGConfig:template/template",(char *)ONS,size)) ShutDown(10,"Cannot load template index");

   limit = size / sizeof(struct OldNameStruct);
   NNS = calloc(limit,sizeof(struct NameStruct));

   for(ns = ONS; ns < (ONS + limit); ns++)
   {
      char fname[256];
      char bname[256];

      ULONG fsize = 0;

      Chk_Abort();

      AFPrintf(NULL,sout,"Template [%-30.30s]: ",ns->name);

///   Convert User data
      ASPrintf(NULL,fname,"DLGConfig:template/%s.template",ns->name);
      UnderScore(fname);

      FileSize(fname,&fsize);

      if(fsize != sizeof(struct Old_User))
      {
         AFPrintf(NULL,sout,"Template already converted or corrupt.\n");
         continue;
      }

      ASPrintf(NULL,bname,"%sbak",fname);
      Copy(fname,bname);

      if(-1 == GetFirstStruct(fname,(char *)&old,sizeof(struct Old_User)))
      {
         AFPrintf(NULL,sout,"No data.\n");
         continue;
      }

///   Actual conversion happens here
      strcpy(new_u.Password,   old.Password);
      new_u.Screen_Len       = old.Screen_Len;
      new_u.Screen_Width     = old.Screen_Width;
      new_u.Ansi_Flag        = old.Ansi_Flag;
      new_u.More_Flag        = old.More_Flag;
      new_u.Help_Level       = old.Help_Level;
      memcpy(new_u.Alias,      old.Alias, 30);
      new_u.Computer_Type    = old.Computer_Type;
      new_u.Daily_Limit      = old.Daily_Limit;
      new_u.Session_Limit    = old.Session_Limit;
      new_u.Daily_Used       = old.Daily_Used;
      new_u.Bulletin_Access  = old.Bulletin_Access;
      new_u.send             = old.send;
      new_u.receive          = old.receive;
      new_u.msgsig           = old.msgsig;
      new_u.filesig          = old.filesig;
      new_u.archiver         = old.archiver;
      new_u.menuset          = old.menuset;
      new_u.fileorder        = old.fileorder;
      new_u.filesince        = old.filesince;
      new_u.charset          = old.charset;
      new_u.Birth_Year       = old.Birth_Year;
      new_u.Last_Area        = (SHORT)old.Last_Area;
      new_u.User_Level       = old.User_Level;
      new_u.Lex_Flag         = old.Lex_Flag;
      new_u.Editor           = old.Editor;
      new_u.Private_Flag     = old.Private_Flag;
      strcpy(new_u.Last_Login, old.Last_Login);
      new_u.Ratio            = old.Ratio;
      new_u.NetMail          = old.NetMail;
      new_u.ThreadMode       = old.ThreadMode;
      strcpy(new_u.Phone,      old.Phone);
      strcpy(new_u.City,       old.City);
      strcpy(new_u.Prov,       old.Prov);
      new_u.Pop_Screen       = old.Pop_Screen;
      new_u.Hot_Keys         = old.Hot_Keys;
      new_u.Total_Calls      = old.Total_Calls;
      new_u.Online_Time      = old.Online_Time;
      new_u.Messages_Entered = old.Messages_Entered;
      new_u.Messages_Read    = old.Messages_Read;
      new_u.Bytes_Uploaded   = old.Bytes_Uploaded;
      new_u.Bytes_Downloaded = old.Bytes_Downloaded;
      new_u.Files_Uploaded   = old.Files_Uploaded;
      new_u.Files_Downloaded = old.Files_Downloaded;
      new_u.Sysop_Pages      = old.Sysop_Pages;
      strcpy(new_u.Address,    old.Address);
      new_u.Birth_Month      = old.Birth_Month;
      new_u.Birth_Day        = old.Birth_Day;
      new_u.Last_File_Area   = (SHORT)old.Last_File_Area;
      strcpy(new_u.stack,      old.stack);
      new_u.UUCP             = old.UUCP;
      strcpy(new_u.Country,    old.Country);
      new_u.Long_Date        = old.Long_Date;
      new_u.DirLimit         = old.DirLimit;
      new_u.credit           = old.credit;
      strcpy(new_u.postal,     old.postal);
      new_u.protocol         = old.protocol;
      new_u.captureflags     = old.captureflags;
      new_u.DateJoined       = old.DateJoined;
//-

      fh = Open(fname,MODE_NEWFILE);

      if(fh)
      {
         Write(fh,&new_u,sizeof(struct USER_DATA));
         Close(fh);
         fh = NULL;
      }
      else
      {
         AFPrintf(NULL,sout,"Could not write new data\n");
         continue;
      }
//-

      AFPrintf(NULL,sout,"Done!\n");
   }


   AFPrintf(NULL,sout,"All Done!\n\n");
   ShutDown(0,NULL);

   for(i = 0; i < limit; i++)
      strcpy(NNS[i].name,ONS[i].name);

   fh = Open("DLGConfig:Template/Template",MODE_NEWFILE);

   if(fh)
   {
      Write(fh,NNS,(limit * sizeof(struct NameStruct)));
      Close(fh);
   }

   ShutDown(0,NULL);
}
//-

/// ShutDown
void ShutDown(int Error, char *ErrStr)
{
   if(ONS)     free(ONS);
   if(NNS)     free(NNS);

   if(fh)      Close(fh);

   if(DLGBase) CloseLibrary(DLGBase);

   if(Error)
   {
      FPuts(sout,ErrStr);
      FPuts(sout,"\n\n");
   }

   exit(Error);
}
//-

/// _CXBRK
void _CXBRK()
{
   ShutDown(5,"Control-C Detected");
}
//-


